// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Synonyms;

public sealed partial class PutSynonymRuleRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, the request will refresh the analyzers with the new synonym rule and wait for the new synonyms to be available before returning.
	/// If <c>false</c>, analyzers will not be reloaded with the new synonym rule
	/// </para>
	/// </summary>
	public bool? Refresh { get => Q<bool?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Create or update a synonym rule.
/// Create or update a synonym rule in a synonym set.
/// </para>
/// <para>
/// If any of the synonym rules included is invalid, the API returns an error.
/// </para>
/// <para>
/// When you update a synonym rule, all analyzers using the synonyms set will be reloaded automatically to reflect the new rule.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Synonyms.Json.PutSynonymRuleRequestConverter))]
public sealed partial class PutSynonymRuleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSynonymRuleRequest(Elastic.Clients.Elasticsearch.Id setId, Elastic.Clients.Elasticsearch.Id ruleId) : base(r => r.Required("set_id", setId).Required("rule_id", ruleId))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSynonymRuleRequest(Elastic.Clients.Elasticsearch.Id setId, Elastic.Clients.Elasticsearch.Id ruleId, string synonyms) : base(r => r.Required("set_id", setId).Required("rule_id", ruleId))
	{
		Synonyms = synonyms;
	}
#if NET7_0_OR_GREATER
	public PutSynonymRuleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutSynonymRuleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SynonymsPutSynonymRule;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "synonyms.put_synonym_rule";

	/// <summary>
	/// <para>
	/// The ID of the synonym rule to be updated or created.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id RuleId { get => P<Elastic.Clients.Elasticsearch.Id>("rule_id"); set => PR("rule_id", value); }

	/// <summary>
	/// <para>
	/// The ID of the synonym set.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id SetId { get => P<Elastic.Clients.Elasticsearch.Id>("set_id"); set => PR("set_id", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request will refresh the analyzers with the new synonym rule and wait for the new synonyms to be available before returning.
	/// If <c>false</c>, analyzers will not be reloaded with the new synonym rule
	/// </para>
	/// </summary>
	public bool? Refresh { get => Q<bool?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// The synonym rule information definition, which must be in Solr format.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Synonyms { get; set; }
}

/// <summary>
/// <para>
/// Create or update a synonym rule.
/// Create or update a synonym rule in a synonym set.
/// </para>
/// <para>
/// If any of the synonym rules included is invalid, the API returns an error.
/// </para>
/// <para>
/// When you update a synonym rule, all analyzers using the synonyms set will be reloaded automatically to reflect the new rule.
/// </para>
/// </summary>
public readonly partial struct PutSynonymRuleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSynonymRuleRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequest instance)
	{
		Instance = instance;
	}

	public PutSynonymRuleRequestDescriptor(Elastic.Clients.Elasticsearch.Id setId, Elastic.Clients.Elasticsearch.Id ruleId)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequest(setId, ruleId);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutSynonymRuleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequest instance) => new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequest(Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the synonym rule to be updated or created.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor RuleId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.RuleId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID of the synonym set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor SetId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.SetId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request will refresh the analyzers with the new synonym rule and wait for the new synonyms to be available before returning.
	/// If <c>false</c>, analyzers will not be reloaded with the new synonym rule
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor Refresh(bool? value = true)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The synonym rule information definition, which must be in Solr format.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor Synonyms(string value)
	{
		Instance.Synonyms = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor(new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRuleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}