// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Synonyms;

public sealed partial class PutSynonymRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c>, the request will refresh the analyzers with the new synonyms set and wait for the new synonyms to be available before returning.
	/// If <c>false</c>, analyzers will not be reloaded with the new synonym set
	/// </para>
	/// </summary>
	public bool? Refresh { get => Q<bool?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Create or update a synonym set.
/// Synonyms sets are limited to a maximum of 10,000 synonym rules per set.
/// If you need to manage more synonym rules, you can create multiple synonym sets.
/// </para>
/// <para>
/// When an existing synonyms set is updated, the search analyzers that use the synonyms set are reloaded automatically for all indices.
/// This is equivalent to invoking the reload search analyzers API for all indices that use the synonyms set.
/// </para>
/// <para>
/// For practical examples of how to create or update a synonyms set, refer to the External documentation.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Synonyms.Json.PutSynonymRequestConverter))]
public sealed partial class PutSynonymRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSynonymRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSynonymRequest(Elastic.Clients.Elasticsearch.Id id, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Synonyms.SynonymRule> synonymsSet) : base(r => r.Required("id", id))
	{
		SynonymsSet = synonymsSet;
	}
#if NET7_0_OR_GREATER
	public PutSynonymRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutSynonymRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SynonymsPutSynonym;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "synonyms.put_synonym";

	/// <summary>
	/// <para>
	/// The ID of the synonyms set to be created or updated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request will refresh the analyzers with the new synonyms set and wait for the new synonyms to be available before returning.
	/// If <c>false</c>, analyzers will not be reloaded with the new synonym set
	/// </para>
	/// </summary>
	public bool? Refresh { get => Q<bool?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// The synonym rules definitions for the synonyms set.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Synonyms.SynonymRule> SynonymsSet { get; set; }
}

/// <summary>
/// <para>
/// Create or update a synonym set.
/// Synonyms sets are limited to a maximum of 10,000 synonym rules per set.
/// If you need to manage more synonym rules, you can create multiple synonym sets.
/// </para>
/// <para>
/// When an existing synonyms set is updated, the search analyzers that use the synonyms set are reloaded automatically for all indices.
/// This is equivalent to invoking the reload search analyzers API for all indices that use the synonyms set.
/// </para>
/// <para>
/// For practical examples of how to create or update a synonyms set, refer to the External documentation.
/// </para>
/// </summary>
public readonly partial struct PutSynonymRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutSynonymRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequest instance)
	{
		Instance = instance;
	}

	public PutSynonymRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequest(id);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutSynonymRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequest instance) => new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequest(Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the synonyms set to be created or updated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request will refresh the analyzers with the new synonyms set and wait for the new synonyms to be available before returning.
	/// If <c>false</c>, analyzers will not be reloaded with the new synonym set
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor Refresh(bool? value = true)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The synonym rules definitions for the synonyms set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor SynonymsSet(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Synonyms.SynonymRule> value)
	{
		Instance.SynonymsSet = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The synonym rules definitions for the synonyms set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor SynonymsSet(params Elastic.Clients.Elasticsearch.Synonyms.SynonymRule[] values)
	{
		Instance.SynonymsSet = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The synonym rules definitions for the synonyms set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor SynonymsSet(params System.Action<Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Synonyms.SynonymRule>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Synonyms.SynonymRuleDescriptor.Build(action));
		}

		Instance.SynonymsSet = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequest Build(System.Action<Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor(new Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.PutSynonymRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}