// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Synonyms;

public sealed partial class GetSynonymsSetsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The starting offset for synonyms sets to retrieve.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// The maximum number of synonyms sets to retrieve.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get all synonym sets.
/// Get a summary of all defined synonym sets.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Synonyms.Json.GetSynonymsSetsRequestConverter))]
public sealed partial class GetSynonymsSetsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestParameters>
{
#if NET7_0_OR_GREATER
	public GetSynonymsSetsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetSynonymsSetsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetSynonymsSetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SynonymsGetSynonymsSets;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "synonyms.get_synonyms_sets";

	/// <summary>
	/// <para>
	/// The starting offset for synonyms sets to retrieve.
	/// </para>
	/// </summary>
	public int? From { get => Q<int?>("from"); set => Q("from", value); }

	/// <summary>
	/// <para>
	/// The maximum number of synonyms sets to retrieve.
	/// </para>
	/// </summary>
	public int? Size { get => Q<int?>("size"); set => Q("size", value); }
}

/// <summary>
/// <para>
/// Get all synonym sets.
/// Get a summary of all defined synonym sets.
/// </para>
/// </summary>
public readonly partial struct GetSynonymsSetsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetSynonymsSetsRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest instance)
	{
		Instance = instance;
	}

	public GetSynonymsSetsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest instance) => new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest(Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The starting offset for synonyms sets to retrieve.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of synonyms sets to retrieve.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor(new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymsSetsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}