// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Synonyms;

public sealed partial class GetSynonymRuleRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get a synonym rule.
/// Get a synonym rule from a synonym set.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Synonyms.Json.GetSynonymRuleRequestConverter))]
public sealed partial class GetSynonymRuleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetSynonymRuleRequest(Elastic.Clients.Elasticsearch.Id setId, Elastic.Clients.Elasticsearch.Id ruleId) : base(r => r.Required("set_id", setId).Required("rule_id", ruleId))
	{
	}
#if NET7_0_OR_GREATER
	public GetSynonymRuleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetSynonymRuleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SynonymsGetSynonymRule;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "synonyms.get_synonym_rule";

	/// <summary>
	/// <para>
	/// The ID of the synonym rule to retrieve.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id RuleId { get => P<Elastic.Clients.Elasticsearch.Id>("rule_id"); set => PR("rule_id", value); }

	/// <summary>
	/// <para>
	/// The ID of the synonym set to retrieve the synonym rule from.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id SetId { get => P<Elastic.Clients.Elasticsearch.Id>("set_id"); set => PR("set_id", value); }
}

/// <summary>
/// <para>
/// Get a synonym rule.
/// Get a synonym rule from a synonym set.
/// </para>
/// </summary>
public readonly partial struct GetSynonymRuleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetSynonymRuleRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequest instance)
	{
		Instance = instance;
	}

	public GetSynonymRuleRequestDescriptor(Elastic.Clients.Elasticsearch.Id setId, Elastic.Clients.Elasticsearch.Id ruleId)
	{
		Instance = new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequest(setId, ruleId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetSynonymRuleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequest instance) => new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequest(Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the synonym rule to retrieve.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor RuleId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.RuleId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The ID of the synonym set to retrieve the synonym rule from.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor SetId(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.SetId = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor(new Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.GetSynonymRuleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}