// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Synonyms;

public sealed partial class DeleteSynonymRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Delete a synonym set.
/// </para>
/// <para>
/// You can only delete a synonyms set that is not in use by any index analyzer.
/// </para>
/// <para>
/// Synonyms sets can be used in synonym graph token filters and synonym token filters.
/// These synonym filters can be used as part of search analyzers.
/// </para>
/// <para>
/// Analyzers need to be loaded when an index is restored (such as when a node starts, or the index becomes open).
/// Even if the analyzer is not used on any field mapping, it still needs to be loaded on the index recovery phase.
/// </para>
/// <para>
/// If any analyzers cannot be loaded, the index becomes unavailable and the cluster status becomes red or yellow as index shards are not available.
/// To prevent that, synonyms sets that are used in analyzers can't be deleted.
/// A delete request in this case will return a 400 response code.
/// </para>
/// <para>
/// To remove a synonyms set, you must first remove all indices that contain analyzers using it.
/// You can migrate an index by creating a new index that does not contain the token filter with the synonyms set, and use the reindex API in order to copy over the index data.
/// Once finished, you can delete the index.
/// When the synonyms set is not used in analyzers, you will be able to delete it.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Synonyms.Json.DeleteSynonymRequestConverter))]
public sealed partial class DeleteSynonymRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteSynonymRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteSynonymRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteSynonymRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SynonymsDeleteSynonym;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => false;

	internal override string OperationName => "synonyms.delete_synonym";

	/// <summary>
	/// <para>
	/// The synonyms set identifier to delete.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }
}

/// <summary>
/// <para>
/// Delete a synonym set.
/// </para>
/// <para>
/// You can only delete a synonyms set that is not in use by any index analyzer.
/// </para>
/// <para>
/// Synonyms sets can be used in synonym graph token filters and synonym token filters.
/// These synonym filters can be used as part of search analyzers.
/// </para>
/// <para>
/// Analyzers need to be loaded when an index is restored (such as when a node starts, or the index becomes open).
/// Even if the analyzer is not used on any field mapping, it still needs to be loaded on the index recovery phase.
/// </para>
/// <para>
/// If any analyzers cannot be loaded, the index becomes unavailable and the cluster status becomes red or yellow as index shards are not available.
/// To prevent that, synonyms sets that are used in analyzers can't be deleted.
/// A delete request in this case will return a 400 response code.
/// </para>
/// <para>
/// To remove a synonyms set, you must first remove all indices that contain analyzers using it.
/// You can migrate an index by creating a new index that does not contain the token filter with the synonyms set, and use the reindex API in order to copy over the index data.
/// Once finished, you can delete the index.
/// When the synonyms set is not used in analyzers, you will be able to delete it.
/// </para>
/// </summary>
public readonly partial struct DeleteSynonymRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteSynonymRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequest instance)
	{
		Instance = instance;
	}

	public DeleteSynonymRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DeleteSynonymRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor(Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequest instance) => new Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequest(Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The synonyms set identifier to delete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequest Build(System.Action<Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor(new Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Synonyms.DeleteSynonymRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}