// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Sql;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Sql.Json.QueryResponseConverter))]
public partial class QueryResponse : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Column headings for the search results. Each object is a column.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Sql.Column>? Columns { get; set; }

	/// <summary>
	/// <para>
	/// The cursor for the next set of paginated results.
	/// For CSV, TSV, and TXT responses, this value is returned in the <c>Cursor</c> HTTP header.
	/// </para>
	/// </summary>
	public string? Cursor { get; set; }

	/// <summary>
	/// <para>
	/// The identifier for the search.
	/// This value is returned only for async and saved synchronous searches.
	/// For CSV, TSV, and TXT responses, this value is returned in the <c>Async-ID</c> HTTP header.
	/// </para>
	/// </summary>
	public string? Id { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response does not contain complete search results.
	/// If <c>is_partial</c> is <c>true</c> and <c>is_running</c> is <c>true</c>, the search is still running.
	/// If <c>is_partial</c> is <c>true</c> but <c>is_running</c> is <c>false</c>, the results are partial due to a failure or timeout.
	/// This value is returned only for async and saved synchronous searches.
	/// For CSV, TSV, and TXT responses, this value is returned in the <c>Async-partial</c> HTTP header.
	/// </para>
	/// </summary>
	public bool? IsPartial { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the search is still running.
	/// If <c>false</c>, the search has finished.
	/// This value is returned only for async and saved synchronous searches.
	/// For CSV, TSV, and TXT responses, this value is returned in the <c>Async-partial</c> HTTP header.
	/// </para>
	/// </summary>
	public bool? IsRunning { get; set; }
}