// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Sql;

public sealed partial class QueryRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The format for the response.
	/// You can also specify a format using the <c>Accept</c> HTTP header.
	/// If you specify both this parameter and the <c>Accept</c> HTTP header, this parameter takes precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.SqlFormat? Format { get => Q<Elastic.Clients.Elasticsearch.Sql.SqlFormat?>("format"); set => Q("format", value); }
}

/// <summary>
/// <para>
/// Get SQL search results.
/// Run an SQL request.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Sql.Json.QueryRequestConverter))]
public sealed partial class QueryRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Sql.QueryRequestParameters>
{
#if NET7_0_OR_GREATER
	public QueryRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public QueryRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SqlQuery;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "sql.query";

	/// <summary>
	/// <para>
	/// The format for the response.
	/// You can also specify a format using the <c>Accept</c> HTTP header.
	/// If you specify both this parameter and the <c>Accept</c> HTTP header, this parameter takes precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.SqlFormat? Format { get => Q<Elastic.Clients.Elasticsearch.Sql.SqlFormat?>("format"); set => Q("format", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response has partial results when there are shard request timeouts or shard failures.
	/// If <c>false</c>, the API returns an error with no partial results.
	/// </para>
	/// </summary>
	public bool? AllowPartialSearchResults { get; set; }

	/// <summary>
	/// <para>
	/// The default catalog (cluster) for queries.
	/// If unspecified, the queries execute on the data in the local cluster only.
	/// </para>
	/// </summary>
	public string? Catalog { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the results are in a columnar fashion: one row represents all the values of a certain column from the current page of results.
	/// The API supports this parameter only for CBOR, JSON, SMILE, and YAML responses.
	/// </para>
	/// </summary>
	public bool? Columnar { get; set; }

	/// <summary>
	/// <para>
	/// The cursor used to retrieve a set of paginated results.
	/// If you specify a cursor, the API only uses the <c>columnar</c> and <c>time_zone</c> request body parameters.
	/// It ignores other request body parameters.
	/// </para>
	/// </summary>
	public string? Cursor { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of rows (or entries) to return in one response.
	/// </para>
	/// </summary>
	public int? FetchSize { get; set; }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the API returns an exception when encountering multiple values for a field.
	/// If <c>true</c>, the API is lenient and returns the first value from the array with no guarantee of consistent results.
	/// </para>
	/// </summary>
	public bool? FieldMultiValueLeniency { get; set; }

	/// <summary>
	/// <para>
	/// The Elasticsearch query DSL for additional filtering.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Filter { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the search can run on frozen indices.
	/// </para>
	/// </summary>
	public bool? IndexUsingFrozen { get; set; }

	/// <summary>
	/// <para>
	/// The retention period for an async or saved synchronous search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, Elasticsearch stores synchronous searches if you also specify the <c>wait_for_completion_timeout</c> parameter.
	/// If <c>false</c>, Elasticsearch only stores async searches that don't finish before the <c>wait_for_completion_timeout</c>.
	/// </para>
	/// </summary>
	public bool? KeepOnCompletion { get; set; }

	/// <summary>
	/// <para>
	/// The minimum retention period for the scroll cursor.
	/// After this time period, a pagination request might fail because the scroll cursor is no longer available.
	/// Subsequent scroll requests prolong the lifetime of the scroll cursor by the duration of <c>page_timeout</c> in the scroll request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? PageTimeout { get; set; }

	/// <summary>
	/// <para>
	/// The values for parameters in the query.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<object>? Params { get; set; }

	/// <summary>
	/// <para>
	/// The SQL query to run.
	/// </para>
	/// </summary>
	public string? Query { get; set; }

	/// <summary>
	/// <para>
	/// The timeout before the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? RequestTimeout { get; set; }

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? RuntimeMappings { get; set; }

	/// <summary>
	/// <para>
	/// The ISO-8601 time zone ID for the search.
	/// </para>
	/// </summary>
	public string? TimeZone { get; set; }

	/// <summary>
	/// <para>
	/// The period to wait for complete results.
	/// It defaults to no timeout, meaning the request waits for complete search results.
	/// If the search doesn't finish within this period, the search becomes async.
	/// </para>
	/// <para>
	/// To save a synchronous search, you must specify this parameter and the <c>keep_on_completion</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? WaitForCompletionTimeout { get; set; }
}

/// <summary>
/// <para>
/// Get SQL search results.
/// Run an SQL request.
/// </para>
/// </summary>
public readonly partial struct QueryRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Sql.QueryRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.QueryRequest instance)
	{
		Instance = instance;
	}

	public QueryRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.QueryRequest instance) => new Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The format for the response.
	/// You can also specify a format using the <c>Accept</c> HTTP header.
	/// If you specify both this parameter and the <c>Accept</c> HTTP header, this parameter takes precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Format(Elastic.Clients.Elasticsearch.Sql.SqlFormat? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response has partial results when there are shard request timeouts or shard failures.
	/// If <c>false</c>, the API returns an error with no partial results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default catalog (cluster) for queries.
	/// If unspecified, the queries execute on the data in the local cluster only.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Catalog(string? value)
	{
		Instance.Catalog = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the results are in a columnar fashion: one row represents all the values of a certain column from the current page of results.
	/// The API supports this parameter only for CBOR, JSON, SMILE, and YAML responses.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Columnar(bool? value = true)
	{
		Instance.Columnar = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The cursor used to retrieve a set of paginated results.
	/// If you specify a cursor, the API only uses the <c>columnar</c> and <c>time_zone</c> request body parameters.
	/// It ignores other request body parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Cursor(string? value)
	{
		Instance.Cursor = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of rows (or entries) to return in one response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor FetchSize(int? value)
	{
		Instance.FetchSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the API returns an exception when encountering multiple values for a field.
	/// If <c>true</c>, the API is lenient and returns the first value from the array with no guarantee of consistent results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor FieldMultiValueLeniency(bool? value = true)
	{
		Instance.FieldMultiValueLeniency = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query DSL for additional filtering.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query DSL for additional filtering.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query DSL for additional filtering.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the search can run on frozen indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor IndexUsingFrozen(bool? value = true)
	{
		Instance.IndexUsingFrozen = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The retention period for an async or saved synchronous search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, Elasticsearch stores synchronous searches if you also specify the <c>wait_for_completion_timeout</c> parameter.
	/// If <c>false</c>, Elasticsearch only stores async searches that don't finish before the <c>wait_for_completion_timeout</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor KeepOnCompletion(bool? value = true)
	{
		Instance.KeepOnCompletion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum retention period for the scroll cursor.
	/// After this time period, a pagination request might fail because the scroll cursor is no longer available.
	/// Subsequent scroll requests prolong the lifetime of the scroll cursor by the duration of <c>page_timeout</c> in the scroll request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor PageTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.PageTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The values for parameters in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Params(System.Collections.Generic.ICollection<object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The values for parameters in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Params(params object[] values)
	{
		Instance.Params = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The SQL query to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The timeout before the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor RequestTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.RequestTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor RuntimeMappings<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor AddRuntimeMapping<T>(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor AddRuntimeMapping<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// The ISO-8601 time zone ID for the search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for complete results.
	/// It defaults to no timeout, meaning the request waits for complete search results.
	/// If the search doesn't finish within this period, the search becomes async.
	/// </para>
	/// <para>
	/// To save a synchronous search, you must specify this parameter and the <c>keep_on_completion</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor WaitForCompletionTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitForCompletionTimeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Sql.QueryRequest Build(System.Action<Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor(new Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Get SQL search results.
/// Run an SQL request.
/// </para>
/// </summary>
public readonly partial struct QueryRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Sql.QueryRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.QueryRequest instance)
	{
		Instance = instance;
	}

	public QueryRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Sql.QueryRequest instance) => new Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The format for the response.
	/// You can also specify a format using the <c>Accept</c> HTTP header.
	/// If you specify both this parameter and the <c>Accept</c> HTTP header, this parameter takes precedence.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Format(Elastic.Clients.Elasticsearch.Sql.SqlFormat? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the response has partial results when there are shard request timeouts or shard failures.
	/// If <c>false</c>, the API returns an error with no partial results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> AllowPartialSearchResults(bool? value = true)
	{
		Instance.AllowPartialSearchResults = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The default catalog (cluster) for queries.
	/// If unspecified, the queries execute on the data in the local cluster only.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Catalog(string? value)
	{
		Instance.Catalog = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the results are in a columnar fashion: one row represents all the values of a certain column from the current page of results.
	/// The API supports this parameter only for CBOR, JSON, SMILE, and YAML responses.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Columnar(bool? value = true)
	{
		Instance.Columnar = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The cursor used to retrieve a set of paginated results.
	/// If you specify a cursor, the API only uses the <c>columnar</c> and <c>time_zone</c> request body parameters.
	/// It ignores other request body parameters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Cursor(string? value)
	{
		Instance.Cursor = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of rows (or entries) to return in one response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> FetchSize(int? value)
	{
		Instance.FetchSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the API returns an exception when encountering multiple values for a field.
	/// If <c>true</c>, the API is lenient and returns the first value from the array with no guarantee of consistent results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> FieldMultiValueLeniency(bool? value = true)
	{
		Instance.FieldMultiValueLeniency = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query DSL for additional filtering.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch query DSL for additional filtering.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the search can run on frozen indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> IndexUsingFrozen(bool? value = true)
	{
		Instance.IndexUsingFrozen = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The retention period for an async or saved synchronous search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, Elasticsearch stores synchronous searches if you also specify the <c>wait_for_completion_timeout</c> parameter.
	/// If <c>false</c>, Elasticsearch only stores async searches that don't finish before the <c>wait_for_completion_timeout</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> KeepOnCompletion(bool? value = true)
	{
		Instance.KeepOnCompletion = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum retention period for the scroll cursor.
	/// After this time period, a pagination request might fail because the scroll cursor is no longer available.
	/// Subsequent scroll requests prolong the lifetime of the scroll cursor by the duration of <c>page_timeout</c> in the scroll request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> PageTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.PageTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The values for parameters in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Params(System.Collections.Generic.ICollection<object>? value)
	{
		Instance.Params = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The values for parameters in the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Params(params object[] values)
	{
		Instance.Params = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The SQL query to run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Query(string? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The timeout before the request fails.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> RequestTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.RequestTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> RuntimeMappings(System.Collections.Generic.IDictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>? value)
	{
		Instance.RuntimeMappings = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> RuntimeMappings()
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// One or more runtime fields for the search request.
	/// These fields take precedence over mapped fields with the same name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> RuntimeMappings(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>>? action)
	{
		Instance.RuntimeMappings = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfFieldRuntimeField<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, Elastic.Clients.Elasticsearch.Mapping.RuntimeField value)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> AddRuntimeMapping(Elastic.Clients.Elasticsearch.Field key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> AddRuntimeMapping(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> key, System.Action<Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>> action)
	{
		Instance.RuntimeMappings ??= new System.Collections.Generic.Dictionary<Elastic.Clients.Elasticsearch.Field, Elastic.Clients.Elasticsearch.Mapping.RuntimeField>();
		Instance.RuntimeMappings.Add(key, Elastic.Clients.Elasticsearch.Mapping.RuntimeFieldDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// The ISO-8601 time zone ID for the search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> TimeZone(string? value)
	{
		Instance.TimeZone = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for complete results.
	/// It defaults to no timeout, meaning the request waits for complete search results.
	/// If the search doesn't finish within this period, the search becomes async.
	/// </para>
	/// <para>
	/// To save a synchronous search, you must specify this parameter and the <c>keep_on_completion</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> WaitForCompletionTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitForCompletionTimeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Sql.QueryRequest Build(System.Action<Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Sql.QueryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.QueryRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}