// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Sql;

public sealed partial class GetAsyncRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The separator for CSV results.
	/// The API supports this parameter only for CSV responses.
	/// </para>
	/// </summary>
	public string? Delimiter { get => Q<string?>("delimiter"); set => Q("delimiter", value); }

	/// <summary>
	/// <para>
	/// The format for the response.
	/// You must specify a format using this parameter or the <c>Accept</c> HTTP header.
	/// If you specify both, the API uses this parameter.
	/// </para>
	/// </summary>
	public string? Format { get => Q<string?>("format"); set => Q("format", value); }

	/// <summary>
	/// <para>
	/// The retention period for the search and its results.
	/// It defaults to the <c>keep_alive</c> period for the original SQL search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get => Q<Elastic.Clients.Elasticsearch.Duration?>("keep_alive"); set => Q("keep_alive", value); }

	/// <summary>
	/// <para>
	/// The period to wait for complete results.
	/// It defaults to no timeout, meaning the request waits for complete search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? WaitForCompletionTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("wait_for_completion_timeout"); set => Q("wait_for_completion_timeout", value); }
}

/// <summary>
/// <para>
/// Get async SQL search results.
/// Get the current status and available results for an async SQL search or stored synchronous SQL search.
/// </para>
/// <para>
/// If the Elasticsearch security features are enabled, only the user who first submitted the SQL search can retrieve the search using this API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Sql.Json.GetAsyncRequestConverter))]
public sealed partial class GetAsyncRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetAsyncRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public GetAsyncRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetAsyncRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SqlGetAsync;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "sql.get_async";

	/// <summary>
	/// <para>
	/// The identifier for the search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// The separator for CSV results.
	/// The API supports this parameter only for CSV responses.
	/// </para>
	/// </summary>
	public string? Delimiter { get => Q<string?>("delimiter"); set => Q("delimiter", value); }

	/// <summary>
	/// <para>
	/// The format for the response.
	/// You must specify a format using this parameter or the <c>Accept</c> HTTP header.
	/// If you specify both, the API uses this parameter.
	/// </para>
	/// </summary>
	public string? Format { get => Q<string?>("format"); set => Q("format", value); }

	/// <summary>
	/// <para>
	/// The retention period for the search and its results.
	/// It defaults to the <c>keep_alive</c> period for the original SQL search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? KeepAlive { get => Q<Elastic.Clients.Elasticsearch.Duration?>("keep_alive"); set => Q("keep_alive", value); }

	/// <summary>
	/// <para>
	/// The period to wait for complete results.
	/// It defaults to no timeout, meaning the request waits for complete search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? WaitForCompletionTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("wait_for_completion_timeout"); set => Q("wait_for_completion_timeout", value); }
}

/// <summary>
/// <para>
/// Get async SQL search results.
/// Get the current status and available results for an async SQL search or stored synchronous SQL search.
/// </para>
/// <para>
/// If the Elasticsearch security features are enabled, only the user who first submitted the SQL search can retrieve the search using this API.
/// </para>
/// </summary>
public readonly partial struct GetAsyncRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Sql.GetAsyncRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetAsyncRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.GetAsyncRequest instance)
	{
		Instance = instance;
	}

	public GetAsyncRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.Sql.GetAsyncRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetAsyncRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.GetAsyncRequest instance) => new Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Sql.GetAsyncRequest(Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The identifier for the search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The separator for CSV results.
	/// The API supports this parameter only for CSV responses.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor Delimiter(string? value)
	{
		Instance.Delimiter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The format for the response.
	/// You must specify a format using this parameter or the <c>Accept</c> HTTP header.
	/// If you specify both, the API uses this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The retention period for the search and its results.
	/// It defaults to the <c>keep_alive</c> period for the original SQL search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor KeepAlive(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.KeepAlive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for complete results.
	/// It defaults to no timeout, meaning the request waits for complete search results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor WaitForCompletionTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.WaitForCompletionTimeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Sql.GetAsyncRequest Build(System.Action<Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor(new Elastic.Clients.Elasticsearch.Sql.GetAsyncRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.GetAsyncRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}