// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Sql;

public sealed partial class DeleteAsyncRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Delete an async SQL search.
/// Delete an async SQL search or a stored synchronous SQL search.
/// If the search is still running, the API cancels it.
/// </para>
/// <para>
/// If the Elasticsearch security features are enabled, only the following users can use this API to delete a search:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Users with the <c>cancel_task</c> cluster privilege.
/// </para>
/// </item>
/// <item>
/// <para>
/// The user who first submitted the search.
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Sql.Json.DeleteAsyncRequestConverter))]
public sealed partial class DeleteAsyncRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteAsyncRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public DeleteAsyncRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DeleteAsyncRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SqlDeleteAsync;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => false;

	internal override string OperationName => "sql.delete_async";

	/// <summary>
	/// <para>
	/// The identifier for the search.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }
}

/// <summary>
/// <para>
/// Delete an async SQL search.
/// Delete an async SQL search or a stored synchronous SQL search.
/// If the search is still running, the API cancels it.
/// </para>
/// <para>
/// If the Elasticsearch security features are enabled, only the following users can use this API to delete a search:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Users with the <c>cancel_task</c> cluster privilege.
/// </para>
/// </item>
/// <item>
/// <para>
/// The user who first submitted the search.
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct DeleteAsyncRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DeleteAsyncRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequest instance)
	{
		Instance = instance;
	}

	public DeleteAsyncRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public DeleteAsyncRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequest instance) => new Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequest(Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The identifier for the search.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequest Build(System.Action<Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor(new Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.DeleteAsyncRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}