// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Sql;

public sealed partial class ClearCursorRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Clear an SQL search cursor.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Sql.Json.ClearCursorRequestConverter))]
public sealed partial class ClearCursorRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCursorRequest(string cursor)
	{
		Cursor = cursor;
	}
#if NET7_0_OR_GREATER
	public ClearCursorRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClearCursorRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClearCursorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SqlClearCursor;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "sql.clear_cursor";

	/// <summary>
	/// <para>
	/// Cursor to clear.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Cursor { get; set; }
}

/// <summary>
/// <para>
/// Clear an SQL search cursor.
/// </para>
/// </summary>
public readonly partial struct ClearCursorRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Sql.ClearCursorRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCursorRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.ClearCursorRequest instance)
	{
		Instance = instance;
	}

	public ClearCursorRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Sql.ClearCursorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor(Elastic.Clients.Elasticsearch.Sql.ClearCursorRequest instance) => new Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Sql.ClearCursorRequest(Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Cursor to clear.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor Cursor(string value)
	{
		Instance.Cursor = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Sql.ClearCursorRequest Build(System.Action<Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor(new Elastic.Clients.Elasticsearch.Sql.ClearCursorRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Sql.ClearCursorRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}