// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement;

public sealed partial class PutLifecycleRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Create or update a policy.
/// Create or update a snapshot lifecycle policy.
/// If the policy already exists, this request increments the policy version.
/// Only the latest version of a policy is stored.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Json.PutLifecycleRequestConverter))]
public sealed partial class PutLifecycleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutLifecycleRequest(Elastic.Clients.Elasticsearch.Name policyId) : base(r => r.Required("policy_id", policyId))
	{
	}
#if NET7_0_OR_GREATER
	public PutLifecycleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutLifecycleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SnapshotLifecycleManagementPutLifecycle;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "slm.put_lifecycle";

	/// <summary>
	/// <para>
	/// The identifier for the snapshot lifecycle policy you want to create or update.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name PolicyId { get => P<Elastic.Clients.Elasticsearch.Name>("policy_id"); set => PR("policy_id", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// Configuration for each snapshot created by the policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SlmConfiguration? Config { get; set; }

	/// <summary>
	/// <para>
	/// Name automatically assigned to each snapshot created by the policy. Date math is supported. To prevent conflicting snapshot names, a UUID is automatically appended to each snapshot name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Name { get; set; }

	/// <summary>
	/// <para>
	/// Repository used to store snapshots created by this policy. This repository must exist prior to the policy’s creation. You can create a repository using the snapshot repository API.
	/// </para>
	/// </summary>
	public string? Repository { get; set; }

	/// <summary>
	/// <para>
	/// Retention rules used to retain and delete snapshots created by the policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention? Retention { get; set; }

	/// <summary>
	/// <para>
	/// Periodic or absolute schedule at which the policy creates snapshots. SLM applies schedule changes immediately.
	/// </para>
	/// </summary>
	public string? Schedule { get; set; }
}

/// <summary>
/// <para>
/// Create or update a policy.
/// Create or update a snapshot lifecycle policy.
/// If the policy already exists, this request increments the policy version.
/// Only the latest version of a policy is stored.
/// </para>
/// </summary>
public readonly partial struct PutLifecycleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutLifecycleRequestDescriptor(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequest instance)
	{
		Instance = instance;
	}

	public PutLifecycleRequestDescriptor(Elastic.Clients.Elasticsearch.Name policyId)
	{
		Instance = new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequest(policyId);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutLifecycleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequest instance) => new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequest(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The identifier for the snapshot lifecycle policy you want to create or update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor PolicyId(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.PolicyId = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration for each snapshot created by the policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Config(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SlmConfiguration? value)
	{
		Instance.Config = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration for each snapshot created by the policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Config()
	{
		Instance.Config = Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SlmConfigurationDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Configuration for each snapshot created by the policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Config(System.Action<Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SlmConfigurationDescriptor>? action)
	{
		Instance.Config = Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.SlmConfigurationDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Name automatically assigned to each snapshot created by the policy. Date math is supported. To prevent conflicting snapshot names, a UUID is automatically appended to each snapshot name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Repository used to store snapshots created by this policy. This repository must exist prior to the policy’s creation. You can create a repository using the snapshot repository API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Repository(string? value)
	{
		Instance.Repository = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retention rules used to retain and delete snapshots created by the policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Retention(Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.Retention? value)
	{
		Instance.Retention = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Retention rules used to retain and delete snapshots created by the policy.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Retention(System.Action<Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor> action)
	{
		Instance.Retention = Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.RetentionDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Periodic or absolute schedule at which the policy creates snapshots. SLM applies schedule changes immediately.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Schedule(string? value)
	{
		Instance.Schedule = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequest Build(System.Action<Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor(new Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.SnapshotLifecycleManagement.PutLifecycleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}