// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

public sealed partial class SnapshotStatusRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error for any snapshots that are unavailable.
	/// If <c>true</c>, the request ignores snapshots that are unavailable, such as those that are corrupted or temporarily cannot be returned.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Get the snapshot status.
/// Get a detailed description of the current state for each shard participating in the snapshot.
/// </para>
/// <para>
/// Note that this API should be used only to obtain detailed shard-level information for ongoing snapshots.
/// If this detail is not needed or you want to obtain information about one or more existing snapshots, use the get snapshot API.
/// </para>
/// <para>
/// If you omit the <c>&lt;snapshot></c> request path parameter, the request retrieves information only for currently running snapshots.
/// This usage is preferred.
/// If needed, you can specify <c>&lt;repository></c> and <c>&lt;snapshot></c> to retrieve information for specific snapshots, even if they're not currently running.
/// </para>
/// <para>
/// WARNING: Using the API to return the status of any snapshots other than currently running snapshots can be expensive.
/// The API requires a read from the repository for each shard in each snapshot.
/// For example, if you have 100 snapshots with 1,000 shards each, an API request that includes all snapshots will require 100,000 reads (100 snapshots x 1,000 shards).
/// </para>
/// <para>
/// Depending on the latency of your storage, such requests can take an extremely long time to return results.
/// These requests can also tax machine resources and, when using cloud storage, incur high processing costs.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.SnapshotStatusRequestConverter))]
public sealed partial class SnapshotStatusRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestParameters>
{
	public SnapshotStatusRequest(Elastic.Clients.Elasticsearch.Name? repository) : base(r => r.Optional("repository", repository))
	{
	}

	public SnapshotStatusRequest(Elastic.Clients.Elasticsearch.Name? repository, Elastic.Clients.Elasticsearch.Names? snapshot) : base(r => r.Optional("repository", repository).Optional("snapshot", snapshot))
	{
	}
#if NET7_0_OR_GREATER
	public SnapshotStatusRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SnapshotStatusRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SnapshotStatusRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SnapshotStatus;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "snapshot.status";

	/// <summary>
	/// <para>
	/// The snapshot repository name used to limit the request.
	/// It supports wildcards (<c>*</c>) if <c>&lt;snapshot></c> isn't specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Repository { get => P<Elastic.Clients.Elasticsearch.Name?>("repository"); set => PO("repository", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of snapshots to retrieve status for.
	/// The default is currently running snapshots.
	/// Wildcards (<c>*</c>) are not supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Names? Snapshot { get => P<Elastic.Clients.Elasticsearch.Names?>("snapshot"); set => PO("snapshot", value); }

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error for any snapshots that are unavailable.
	/// If <c>true</c>, the request ignores snapshots that are unavailable, such as those that are corrupted or temporarily cannot be returned.
	/// </para>
	/// </summary>
	public bool? IgnoreUnavailable { get => Q<bool?>("ignore_unavailable"); set => Q("ignore_unavailable", value); }

	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }
}

/// <summary>
/// <para>
/// Get the snapshot status.
/// Get a detailed description of the current state for each shard participating in the snapshot.
/// </para>
/// <para>
/// Note that this API should be used only to obtain detailed shard-level information for ongoing snapshots.
/// If this detail is not needed or you want to obtain information about one or more existing snapshots, use the get snapshot API.
/// </para>
/// <para>
/// If you omit the <c>&lt;snapshot></c> request path parameter, the request retrieves information only for currently running snapshots.
/// This usage is preferred.
/// If needed, you can specify <c>&lt;repository></c> and <c>&lt;snapshot></c> to retrieve information for specific snapshots, even if they're not currently running.
/// </para>
/// <para>
/// WARNING: Using the API to return the status of any snapshots other than currently running snapshots can be expensive.
/// The API requires a read from the repository for each shard in each snapshot.
/// For example, if you have 100 snapshots with 1,000 shards each, an API request that includes all snapshots will require 100,000 reads (100 snapshots x 1,000 shards).
/// </para>
/// <para>
/// Depending on the latency of your storage, such requests can take an extremely long time to return results.
/// These requests can also tax machine resources and, when using cloud storage, incur high processing costs.
/// </para>
/// </summary>
public readonly partial struct SnapshotStatusRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnapshotStatusRequestDescriptor(Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest instance)
	{
		Instance = instance;
	}

	public SnapshotStatusRequestDescriptor(Elastic.Clients.Elasticsearch.Name? repository)
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest(repository);
	}

	public SnapshotStatusRequestDescriptor(Elastic.Clients.Elasticsearch.Name? repository, Elastic.Clients.Elasticsearch.Names? snapshot)
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest(repository, snapshot);
	}

	public SnapshotStatusRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest instance) => new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest(Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The snapshot repository name used to limit the request.
	/// It supports wildcards (<c>*</c>) if <c>&lt;snapshot></c> isn't specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor Repository(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Repository = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of snapshots to retrieve status for.
	/// The default is currently running snapshots.
	/// Wildcards (<c>*</c>) are not supported.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor Snapshot(Elastic.Clients.Elasticsearch.Names? value)
	{
		Instance.Snapshot = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>false</c>, the request returns an error for any snapshots that are unavailable.
	/// If <c>true</c>, the request ignores snapshots that are unavailable, such as those that are corrupted or temporarily cannot be returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor IgnoreUnavailable(bool? value = true)
	{
		Instance.IgnoreUnavailable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.SnapshotStatusRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}