// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.RepositoryAnalyzeResponseConverter))]
public sealed partial class RepositoryAnalyzeResponse : Elastic.Transport.Products.Elasticsearch.ElasticsearchResponse
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RepositoryAnalyzeResponse()
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RepositoryAnalyzeResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of blobs written to the repository during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int BlobCount { get; set; }

	/// <summary>
	/// <para>
	/// The path in the repository under which all the blobs were written during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string BlobPath { get; set; }

	/// <summary>
	/// <para>
	/// The number of write operations performed concurrently during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Concurrency { get; set; }

	/// <summary>
	/// <para>
	/// The node that coordinated the analysis and performed the final cleanup.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo CoordinatingNode { get; set; }

	/// <summary>
	/// <para>
	/// The time it took to delete all the blobs in the container.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration DeleteElapsed { get; set; }

	/// <summary>
	/// <para>
	/// The time it took to delete all the blobs in the container, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan DeleteElapsedNanos { get; set; }

	/// <summary>
	/// <para>
	/// A description of every read and write operation performed during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.DetailsInfo Details { get; set; }

	/// <summary>
	/// <para>
	/// The limit on the number of nodes on which early read operations were performed after writing each blob.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int EarlyReadNodeCount { get; set; }

	/// <summary>
	/// <para>
	/// A list of correctness issues detected, which is empty if the API succeeded.
	/// It is included to emphasize that a successful response does not guarantee correct behaviour in future.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> IssuesDetected { get; set; }

	/// <summary>
	/// <para>
	/// The time it took to retrieve a list of all the blobs in the container.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Duration ListingElapsed { get; set; }

	/// <summary>
	/// <para>
	/// The time it took to retrieve a list of all the blobs in the container, in nanoseconds.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan ListingElapsedNanos { get; set; }

	/// <summary>
	/// <para>
	/// The limit on the size of a blob written during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize MaxBlobSize { get; set; }

	/// <summary>
	/// <para>
	/// The limit, in bytes, on the size of a blob written during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MaxBlobSizeBytes { get; set; }

	/// <summary>
	/// <para>
	/// The limit on the total size of all blob written during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize MaxTotalDataSize { get; set; }

	/// <summary>
	/// <para>
	/// The limit, in bytes, on the total size of all blob written during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MaxTotalDataSizeBytes { get; set; }

	/// <summary>
	/// <para>
	/// The probability of performing rare actions during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double RareActionProbability { get; set; }

	/// <summary>
	/// <para>
	/// The limit on the number of nodes on which read operations were performed after writing each blob.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ReadNodeCount { get; set; }

	/// <summary>
	/// <para>
	/// The name of the repository that was the subject of the analysis.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Repository { get; set; }

	/// <summary>
	/// <para>
	/// The seed for the pseudo-random number generator used to generate the operations used during the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Seed { get; set; }

	/// <summary>
	/// <para>
	/// A collection of statistics that summarize the results of the test.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.SummaryInfo Summary { get; set; }
}