// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot.Json;

public sealed partial class RepositoryAnalyzeResponseConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse>
{
	private static readonly System.Text.Json.JsonEncodedText PropBlobCount = System.Text.Json.JsonEncodedText.Encode("blob_count");
	private static readonly System.Text.Json.JsonEncodedText PropBlobPath = System.Text.Json.JsonEncodedText.Encode("blob_path");
	private static readonly System.Text.Json.JsonEncodedText PropConcurrency = System.Text.Json.JsonEncodedText.Encode("concurrency");
	private static readonly System.Text.Json.JsonEncodedText PropCoordinatingNode = System.Text.Json.JsonEncodedText.Encode("coordinating_node");
	private static readonly System.Text.Json.JsonEncodedText PropDeleteElapsed = System.Text.Json.JsonEncodedText.Encode("delete_elapsed");
	private static readonly System.Text.Json.JsonEncodedText PropDeleteElapsedNanos = System.Text.Json.JsonEncodedText.Encode("delete_elapsed_nanos");
	private static readonly System.Text.Json.JsonEncodedText PropDetails = System.Text.Json.JsonEncodedText.Encode("details");
	private static readonly System.Text.Json.JsonEncodedText PropEarlyReadNodeCount = System.Text.Json.JsonEncodedText.Encode("early_read_node_count");
	private static readonly System.Text.Json.JsonEncodedText PropIssuesDetected = System.Text.Json.JsonEncodedText.Encode("issues_detected");
	private static readonly System.Text.Json.JsonEncodedText PropListingElapsed = System.Text.Json.JsonEncodedText.Encode("listing_elapsed");
	private static readonly System.Text.Json.JsonEncodedText PropListingElapsedNanos = System.Text.Json.JsonEncodedText.Encode("listing_elapsed_nanos");
	private static readonly System.Text.Json.JsonEncodedText PropMaxBlobSize = System.Text.Json.JsonEncodedText.Encode("max_blob_size");
	private static readonly System.Text.Json.JsonEncodedText PropMaxBlobSizeBytes = System.Text.Json.JsonEncodedText.Encode("max_blob_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMaxTotalDataSize = System.Text.Json.JsonEncodedText.Encode("max_total_data_size");
	private static readonly System.Text.Json.JsonEncodedText PropMaxTotalDataSizeBytes = System.Text.Json.JsonEncodedText.Encode("max_total_data_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropRareActionProbability = System.Text.Json.JsonEncodedText.Encode("rare_action_probability");
	private static readonly System.Text.Json.JsonEncodedText PropReadNodeCount = System.Text.Json.JsonEncodedText.Encode("read_node_count");
	private static readonly System.Text.Json.JsonEncodedText PropRepository = System.Text.Json.JsonEncodedText.Encode("repository");
	private static readonly System.Text.Json.JsonEncodedText PropSeed = System.Text.Json.JsonEncodedText.Encode("seed");
	private static readonly System.Text.Json.JsonEncodedText PropSummary = System.Text.Json.JsonEncodedText.Encode("summary");

	public override Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propBlobCount = default;
		LocalJsonValue<string> propBlobPath = default;
		LocalJsonValue<int> propConcurrency = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Snapshot.SnapshotNodeInfo> propCoordinatingNode = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propDeleteElapsed = default;
		LocalJsonValue<System.TimeSpan> propDeleteElapsedNanos = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Snapshot.DetailsInfo> propDetails = default;
		LocalJsonValue<int> propEarlyReadNodeCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propIssuesDetected = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration> propListingElapsed = default;
		LocalJsonValue<System.TimeSpan> propListingElapsedNanos = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propMaxBlobSize = default;
		LocalJsonValue<long> propMaxBlobSizeBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propMaxTotalDataSize = default;
		LocalJsonValue<long> propMaxTotalDataSizeBytes = default;
		LocalJsonValue<double> propRareActionProbability = default;
		LocalJsonValue<int> propReadNodeCount = default;
		LocalJsonValue<string> propRepository = default;
		LocalJsonValue<long> propSeed = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Snapshot.SummaryInfo> propSummary = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBlobCount.TryReadProperty(ref reader, options, PropBlobCount, null))
			{
				continue;
			}

			if (propBlobPath.TryReadProperty(ref reader, options, PropBlobPath, null))
			{
				continue;
			}

			if (propConcurrency.TryReadProperty(ref reader, options, PropConcurrency, null))
			{
				continue;
			}

			if (propCoordinatingNode.TryReadProperty(ref reader, options, PropCoordinatingNode, null))
			{
				continue;
			}

			if (propDeleteElapsed.TryReadProperty(ref reader, options, PropDeleteElapsed, null))
			{
				continue;
			}

			if (propDeleteElapsedNanos.TryReadProperty(ref reader, options, PropDeleteElapsedNanos, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (propDetails.TryReadProperty(ref reader, options, PropDetails, null))
			{
				continue;
			}

			if (propEarlyReadNodeCount.TryReadProperty(ref reader, options, PropEarlyReadNodeCount, null))
			{
				continue;
			}

			if (propIssuesDetected.TryReadProperty(ref reader, options, PropIssuesDetected, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (propListingElapsed.TryReadProperty(ref reader, options, PropListingElapsed, null))
			{
				continue;
			}

			if (propListingElapsedNanos.TryReadProperty(ref reader, options, PropListingElapsedNanos, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker))))
			{
				continue;
			}

			if (propMaxBlobSize.TryReadProperty(ref reader, options, PropMaxBlobSize, null))
			{
				continue;
			}

			if (propMaxBlobSizeBytes.TryReadProperty(ref reader, options, PropMaxBlobSizeBytes, null))
			{
				continue;
			}

			if (propMaxTotalDataSize.TryReadProperty(ref reader, options, PropMaxTotalDataSize, null))
			{
				continue;
			}

			if (propMaxTotalDataSizeBytes.TryReadProperty(ref reader, options, PropMaxTotalDataSizeBytes, null))
			{
				continue;
			}

			if (propRareActionProbability.TryReadProperty(ref reader, options, PropRareActionProbability, null))
			{
				continue;
			}

			if (propReadNodeCount.TryReadProperty(ref reader, options, PropReadNodeCount, null))
			{
				continue;
			}

			if (propRepository.TryReadProperty(ref reader, options, PropRepository, null))
			{
				continue;
			}

			if (propSeed.TryReadProperty(ref reader, options, PropSeed, null))
			{
				continue;
			}

			if (propSummary.TryReadProperty(ref reader, options, PropSummary, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BlobCount = propBlobCount.Value,
			BlobPath = propBlobPath.Value,
			Concurrency = propConcurrency.Value,
			CoordinatingNode = propCoordinatingNode.Value,
			DeleteElapsed = propDeleteElapsed.Value,
			DeleteElapsedNanos = propDeleteElapsedNanos.Value,
			Details = propDetails.Value,
			EarlyReadNodeCount = propEarlyReadNodeCount.Value,
			IssuesDetected = propIssuesDetected.Value,
			ListingElapsed = propListingElapsed.Value,
			ListingElapsedNanos = propListingElapsedNanos.Value,
			MaxBlobSize = propMaxBlobSize.Value,
			MaxBlobSizeBytes = propMaxBlobSizeBytes.Value,
			MaxTotalDataSize = propMaxTotalDataSize.Value,
			MaxTotalDataSizeBytes = propMaxTotalDataSizeBytes.Value,
			RareActionProbability = propRareActionProbability.Value,
			ReadNodeCount = propReadNodeCount.Value,
			Repository = propRepository.Value,
			Seed = propSeed.Value,
			Summary = propSummary.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeResponse value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBlobCount, value.BlobCount, null, null);
		writer.WriteProperty(options, PropBlobPath, value.BlobPath, null, null);
		writer.WriteProperty(options, PropConcurrency, value.Concurrency, null, null);
		writer.WriteProperty(options, PropCoordinatingNode, value.CoordinatingNode, null, null);
		writer.WriteProperty(options, PropDeleteElapsed, value.DeleteElapsed, null, null);
		writer.WriteProperty(options, PropDeleteElapsedNanos, value.DeleteElapsedNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteProperty(options, PropDetails, value.Details, null, null);
		writer.WriteProperty(options, PropEarlyReadNodeCount, value.EarlyReadNodeCount, null, null);
		writer.WriteProperty(options, PropIssuesDetected, value.IssuesDetected, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropListingElapsed, value.ListingElapsed, null, null);
		writer.WriteProperty(options, PropListingElapsedNanos, value.ListingElapsedNanos, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanNanosMarker)));
		writer.WriteProperty(options, PropMaxBlobSize, value.MaxBlobSize, null, null);
		writer.WriteProperty(options, PropMaxBlobSizeBytes, value.MaxBlobSizeBytes, null, null);
		writer.WriteProperty(options, PropMaxTotalDataSize, value.MaxTotalDataSize, null, null);
		writer.WriteProperty(options, PropMaxTotalDataSizeBytes, value.MaxTotalDataSizeBytes, null, null);
		writer.WriteProperty(options, PropRareActionProbability, value.RareActionProbability, null, null);
		writer.WriteProperty(options, PropReadNodeCount, value.ReadNodeCount, null, null);
		writer.WriteProperty(options, PropRepository, value.Repository, null, null);
		writer.WriteProperty(options, PropSeed, value.Seed, null, null);
		writer.WriteProperty(options, PropSummary, value.Summary, null, null);
		writer.WriteEndObject();
	}
}