// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

public sealed partial class RepositoryAnalyzeRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The total number of blobs to write to the repository during the test.
	/// For realistic experiments, you should set it to at least <c>2000</c>.
	/// </para>
	/// </summary>
	public int? BlobCount { get => Q<int?>("blob_count"); set => Q("blob_count", value); }

	/// <summary>
	/// <para>
	/// The number of operations to run concurrently during the test.
	/// </para>
	/// </summary>
	public int? Concurrency { get => Q<int?>("concurrency"); set => Q("concurrency", value); }

	/// <summary>
	/// <para>
	/// Indicates whether to return detailed results, including timing information for every operation performed during the analysis.
	/// If false, it returns only a summary of the analysis.
	/// </para>
	/// </summary>
	public bool? Detailed { get => Q<bool?>("detailed"); set => Q("detailed", value); }

	/// <summary>
	/// <para>
	/// The number of nodes on which to perform an early read operation while writing each blob.
	/// Early read operations are only rarely performed.
	/// </para>
	/// </summary>
	public int? EarlyReadNodeCount { get => Q<int?>("early_read_node_count"); set => Q("early_read_node_count", value); }

	/// <summary>
	/// <para>
	/// The maximum size of a blob to be written during the test.
	/// For realistic experiments, you should set it to at least <c>2gb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxBlobSize { get => Q<Elastic.Clients.Elasticsearch.ByteSize?>("max_blob_size"); set => Q("max_blob_size", value); }

	/// <summary>
	/// <para>
	/// An upper limit on the total size of all the blobs written during the test.
	/// For realistic experiments, you should set it to at least <c>1tb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxTotalDataSize { get => Q<Elastic.Clients.Elasticsearch.ByteSize?>("max_total_data_size"); set => Q("max_total_data_size", value); }

	/// <summary>
	/// <para>
	/// The probability of performing a rare action such as an early read, an overwrite, or an aborted write on each blob.
	/// </para>
	/// </summary>
	public double? RareActionProbability { get => Q<double?>("rare_action_probability"); set => Q("rare_action_probability", value); }

	/// <summary>
	/// <para>
	/// Indicates whether to rarely cancel writes before they complete.
	/// </para>
	/// </summary>
	public bool? RarelyAbortWrites { get => Q<bool?>("rarely_abort_writes"); set => Q("rarely_abort_writes", value); }

	/// <summary>
	/// <para>
	/// The number of nodes on which to read a blob after writing.
	/// </para>
	/// </summary>
	public int? ReadNodeCount { get => Q<int?>("read_node_count"); set => Q("read_node_count", value); }

	/// <summary>
	/// <para>
	/// The minimum number of linearizable register operations to perform in total.
	/// For realistic experiments, you should set it to at least <c>100</c>.
	/// </para>
	/// </summary>
	public int? RegisterOperationCount { get => Q<int?>("register_operation_count"); set => Q("register_operation_count", value); }

	/// <summary>
	/// <para>
	/// The seed for the pseudo-random number generator used to generate the list of operations performed during the test.
	/// To repeat the same set of operations in multiple experiments, use the same seed in each experiment.
	/// Note that the operations are performed concurrently so might not always happen in the same order on each run.
	/// </para>
	/// </summary>
	public int? Seed { get => Q<int?>("seed"); set => Q("seed", value); }

	/// <summary>
	/// <para>
	/// The period of time to wait for the test to complete.
	/// If no response is received before the timeout expires, the test is cancelled and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Analyze a snapshot repository.
/// </para>
/// <para>
/// Performs operations on a snapshot repository in order to check for incorrect behaviour.
/// </para>
/// <para>
/// There are a large number of third-party storage systems available, not all of which are suitable for use as a snapshot repository by Elasticsearch.
/// Some storage systems behave incorrectly, or perform poorly, especially when accessed concurrently by multiple clients as the nodes of an Elasticsearch cluster do.
/// This API performs a collection of read and write operations on your repository which are designed to detect incorrect behaviour and to measure the performance characteristics of your storage system.
/// </para>
/// <para>
/// The default values for the parameters are deliberately low to reduce the impact of running an analysis inadvertently and to provide a sensible starting point for your investigations.
/// Run your first analysis with the default parameter values to check for simple problems.
/// Some repositories may behave correctly when lightly loaded but incorrectly under production-like workloads.
/// If the first analysis is successful, run a sequence of increasingly large analyses until you encounter a failure or you reach a <c>blob_count</c> of at least <c>2000</c>, a <c>max_blob_size</c> of at least <c>2gb</c>, a <c>max_total_data_size</c> of at least <c>1tb</c>, and a <c>register_operation_count</c> of at least <c>100</c>.
/// Always specify a generous timeout, possibly <c>1h</c> or longer, to allow time for each analysis to run to completion.
/// Some repositories may behave correctly when accessed by a small number of Elasticsearch nodes but incorrectly when accessed concurrently by a production-scale cluster.
/// Perform the analyses using a multi-node cluster of a similar size to your production cluster so that it can detect any problems that only arise when the repository is accessed by many nodes at once.
/// </para>
/// <para>
/// If the analysis fails, Elasticsearch detected that your repository behaved unexpectedly.
/// This usually means you are using a third-party storage system with an incorrect or incompatible implementation of the API it claims to support.
/// If so, this storage system is not suitable for use as a snapshot repository.
/// Repository analysis triggers conditions that occur only rarely when taking snapshots in a production system.
/// Snapshotting to unsuitable storage may appear to work correctly most of the time despite repository analysis failures.
/// However your snapshot data is at risk if you store it in a snapshot repository that does not reliably pass repository analysis.
/// You can demonstrate that the analysis failure is due to an incompatible storage implementation by verifying that Elasticsearch does not detect the same problem when analysing the reference implementation of the storage protocol you are using.
/// For instance, if you are using storage that offers an API which the supplier claims to be compatible with AWS S3, verify that repositories in AWS S3 do not fail repository analysis.
/// This allows you to demonstrate to your storage supplier that a repository analysis failure must only be caused by an incompatibility with AWS S3 and cannot be attributed to a problem in Elasticsearch.
/// Please do not report Elasticsearch issues involving third-party storage systems unless you can demonstrate that the same issue exists when analysing a repository that uses the reference implementation of the same storage protocol.
/// You will need to work with the supplier of your storage system to address the incompatibilities that Elasticsearch detects.
/// </para>
/// <para>
/// If the analysis is successful, the API returns details of the testing process, optionally including how long each operation took.
/// You can use this information to determine the performance of your storage system.
/// If any operation fails or returns an incorrect result, the API returns an error.
/// If the API returns an error, it may not have removed all the data it wrote to the repository.
/// The error will indicate the location of any leftover data and this path is also recorded in the Elasticsearch logs.
/// You should verify that this location has been cleaned up correctly.
/// If there is still leftover data at the specified location, you should manually remove it.
/// </para>
/// <para>
/// If the connection from your client to Elasticsearch is closed while the client is waiting for the result of the analysis, the test is cancelled.
/// Some clients are configured to close their connection if no response is received within a certain timeout.
/// An analysis takes a long time to complete so you might need to relax any such client-side timeouts.
/// On cancellation the analysis attempts to clean up the data it was writing, but it may not be able to remove it all.
/// The path to the leftover data is recorded in the Elasticsearch logs.
/// You should verify that this location has been cleaned up correctly.
/// If there is still leftover data at the specified location, you should manually remove it.
/// </para>
/// <para>
/// If the analysis is successful then it detected no incorrect behaviour, but this does not mean that correct behaviour is guaranteed.
/// The analysis attempts to detect common bugs but it does not offer 100% coverage.
/// Additionally, it does not test the following:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Your repository must perform durable writes. Once a blob has been written it must remain in place until it is deleted, even after a power loss or similar disaster.
/// </para>
/// </item>
/// <item>
/// <para>
/// Your repository must not suffer from silent data corruption. Once a blob has been written, its contents must remain unchanged until it is deliberately modified or deleted.
/// </para>
/// </item>
/// <item>
/// <para>
/// Your repository must behave correctly even if connectivity from the cluster is disrupted. Reads and writes may fail in this case, but they must not return incorrect results.
/// </para>
/// </item>
/// </list>
/// <para>
/// IMPORTANT: An analysis writes a substantial amount of data to your repository and then reads it back again.
/// This consumes bandwidth on the network between the cluster and the repository, and storage space and I/O bandwidth on the repository itself.
/// You must ensure this load does not affect other users of these systems.
/// Analyses respect the repository settings <c>max_snapshot_bytes_per_sec</c> and <c>max_restore_bytes_per_sec</c> if available and the cluster setting <c>indices.recovery.max_bytes_per_sec</c> which you can use to limit the bandwidth they consume.
/// </para>
/// <para>
/// NOTE: This API is intended for exploratory use by humans.
/// You should expect the request parameters and the response format to vary in future versions.
/// The response exposes immplementation details of the analysis which may change from version to version.
/// </para>
/// <para>
/// NOTE: Different versions of Elasticsearch may perform different checks for repository compatibility, with newer versions typically being stricter than older ones.
/// A storage system that passes repository analysis with one version of Elasticsearch may fail with a different version.
/// This indicates it behaves incorrectly in ways that the former version did not detect.
/// You must work with the supplier of your storage system to address the incompatibilities detected by the repository analysis API in any version of Elasticsearch.
/// </para>
/// <para>
/// NOTE: This API may not work correctly in a mixed-version cluster.
/// </para>
/// <para>
/// <em>Implementation details</em>
/// </para>
/// <para>
/// NOTE: This section of documentation describes how the repository analysis API works in this version of Elasticsearch, but you should expect the implementation to vary between versions.
/// The request parameters and response format depend on details of the implementation so may also be different in newer versions.
/// </para>
/// <para>
/// The analysis comprises a number of blob-level tasks, as set by the <c>blob_count</c> parameter and a number of compare-and-exchange operations on linearizable registers, as set by the <c>register_operation_count</c> parameter.
/// These tasks are distributed over the data and master-eligible nodes in the cluster for execution.
/// </para>
/// <para>
/// For most blob-level tasks, the executing node first writes a blob to the repository and then instructs some of the other nodes in the cluster to attempt to read the data it just wrote.
/// The size of the blob is chosen randomly, according to the <c>max_blob_size</c> and <c>max_total_data_size</c> parameters.
/// If any of these reads fails then the repository does not implement the necessary read-after-write semantics that Elasticsearch requires.
/// </para>
/// <para>
/// For some blob-level tasks, the executing node will instruct some of its peers to attempt to read the data before the writing process completes.
/// These reads are permitted to fail, but must not return partial data.
/// If any read returns partial data then the repository does not implement the necessary atomicity semantics that Elasticsearch requires.
/// </para>
/// <para>
/// For some blob-level tasks, the executing node will overwrite the blob while its peers are reading it.
/// In this case the data read may come from either the original or the overwritten blob, but the read operation must not return partial data or a mix of data from the two blobs.
/// If any of these reads returns partial data or a mix of the two blobs then the repository does not implement the necessary atomicity semantics that Elasticsearch requires for overwrites.
/// </para>
/// <para>
/// The executing node will use a variety of different methods to write the blob.
/// For instance, where applicable, it will use both single-part and multi-part uploads.
/// Similarly, the reading nodes will use a variety of different methods to read the data back again.
/// For instance they may read the entire blob from start to end or may read only a subset of the data.
/// </para>
/// <para>
/// For some blob-level tasks, the executing node will cancel the write before it is complete.
/// In this case, it still instructs some of the other nodes in the cluster to attempt to read the blob but all of these reads must fail to find the blob.
/// </para>
/// <para>
/// Linearizable registers are special blobs that Elasticsearch manipulates using an atomic compare-and-exchange operation.
/// This operation ensures correct and strongly-consistent behavior even when the blob is accessed by multiple nodes at the same time.
/// The detailed implementation of the compare-and-exchange operation on linearizable registers varies by repository type.
/// Repository analysis verifies that that uncontended compare-and-exchange operations on a linearizable register blob always succeed.
/// Repository analysis also verifies that contended operations either succeed or report the contention but do not return incorrect results.
/// If an operation fails due to contention, Elasticsearch retries the operation until it succeeds.
/// Most of the compare-and-exchange operations performed by repository analysis atomically increment a counter which is represented as an 8-byte blob.
/// Some operations also verify the behavior on small blobs with sizes other than 8 bytes.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.RepositoryAnalyzeRequestConverter))]
public sealed partial class RepositoryAnalyzeRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RepositoryAnalyzeRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("repository", name))
	{
	}
#if NET7_0_OR_GREATER
	public RepositoryAnalyzeRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RepositoryAnalyzeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SnapshotRepositoryAnalyze;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "snapshot.repository_analyze";

	/// <summary>
	/// <para>
	/// The name of the repository.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("repository"); set => PR("repository", value); }

	/// <summary>
	/// <para>
	/// The total number of blobs to write to the repository during the test.
	/// For realistic experiments, you should set it to at least <c>2000</c>.
	/// </para>
	/// </summary>
	public int? BlobCount { get => Q<int?>("blob_count"); set => Q("blob_count", value); }

	/// <summary>
	/// <para>
	/// The number of operations to run concurrently during the test.
	/// </para>
	/// </summary>
	public int? Concurrency { get => Q<int?>("concurrency"); set => Q("concurrency", value); }

	/// <summary>
	/// <para>
	/// Indicates whether to return detailed results, including timing information for every operation performed during the analysis.
	/// If false, it returns only a summary of the analysis.
	/// </para>
	/// </summary>
	public bool? Detailed { get => Q<bool?>("detailed"); set => Q("detailed", value); }

	/// <summary>
	/// <para>
	/// The number of nodes on which to perform an early read operation while writing each blob.
	/// Early read operations are only rarely performed.
	/// </para>
	/// </summary>
	public int? EarlyReadNodeCount { get => Q<int?>("early_read_node_count"); set => Q("early_read_node_count", value); }

	/// <summary>
	/// <para>
	/// The maximum size of a blob to be written during the test.
	/// For realistic experiments, you should set it to at least <c>2gb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxBlobSize { get => Q<Elastic.Clients.Elasticsearch.ByteSize?>("max_blob_size"); set => Q("max_blob_size", value); }

	/// <summary>
	/// <para>
	/// An upper limit on the total size of all the blobs written during the test.
	/// For realistic experiments, you should set it to at least <c>1tb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxTotalDataSize { get => Q<Elastic.Clients.Elasticsearch.ByteSize?>("max_total_data_size"); set => Q("max_total_data_size", value); }

	/// <summary>
	/// <para>
	/// The probability of performing a rare action such as an early read, an overwrite, or an aborted write on each blob.
	/// </para>
	/// </summary>
	public double? RareActionProbability { get => Q<double?>("rare_action_probability"); set => Q("rare_action_probability", value); }

	/// <summary>
	/// <para>
	/// Indicates whether to rarely cancel writes before they complete.
	/// </para>
	/// </summary>
	public bool? RarelyAbortWrites { get => Q<bool?>("rarely_abort_writes"); set => Q("rarely_abort_writes", value); }

	/// <summary>
	/// <para>
	/// The number of nodes on which to read a blob after writing.
	/// </para>
	/// </summary>
	public int? ReadNodeCount { get => Q<int?>("read_node_count"); set => Q("read_node_count", value); }

	/// <summary>
	/// <para>
	/// The minimum number of linearizable register operations to perform in total.
	/// For realistic experiments, you should set it to at least <c>100</c>.
	/// </para>
	/// </summary>
	public int? RegisterOperationCount { get => Q<int?>("register_operation_count"); set => Q("register_operation_count", value); }

	/// <summary>
	/// <para>
	/// The seed for the pseudo-random number generator used to generate the list of operations performed during the test.
	/// To repeat the same set of operations in multiple experiments, use the same seed in each experiment.
	/// Note that the operations are performed concurrently so might not always happen in the same order on each run.
	/// </para>
	/// </summary>
	public int? Seed { get => Q<int?>("seed"); set => Q("seed", value); }

	/// <summary>
	/// <para>
	/// The period of time to wait for the test to complete.
	/// If no response is received before the timeout expires, the test is cancelled and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Analyze a snapshot repository.
/// </para>
/// <para>
/// Performs operations on a snapshot repository in order to check for incorrect behaviour.
/// </para>
/// <para>
/// There are a large number of third-party storage systems available, not all of which are suitable for use as a snapshot repository by Elasticsearch.
/// Some storage systems behave incorrectly, or perform poorly, especially when accessed concurrently by multiple clients as the nodes of an Elasticsearch cluster do.
/// This API performs a collection of read and write operations on your repository which are designed to detect incorrect behaviour and to measure the performance characteristics of your storage system.
/// </para>
/// <para>
/// The default values for the parameters are deliberately low to reduce the impact of running an analysis inadvertently and to provide a sensible starting point for your investigations.
/// Run your first analysis with the default parameter values to check for simple problems.
/// Some repositories may behave correctly when lightly loaded but incorrectly under production-like workloads.
/// If the first analysis is successful, run a sequence of increasingly large analyses until you encounter a failure or you reach a <c>blob_count</c> of at least <c>2000</c>, a <c>max_blob_size</c> of at least <c>2gb</c>, a <c>max_total_data_size</c> of at least <c>1tb</c>, and a <c>register_operation_count</c> of at least <c>100</c>.
/// Always specify a generous timeout, possibly <c>1h</c> or longer, to allow time for each analysis to run to completion.
/// Some repositories may behave correctly when accessed by a small number of Elasticsearch nodes but incorrectly when accessed concurrently by a production-scale cluster.
/// Perform the analyses using a multi-node cluster of a similar size to your production cluster so that it can detect any problems that only arise when the repository is accessed by many nodes at once.
/// </para>
/// <para>
/// If the analysis fails, Elasticsearch detected that your repository behaved unexpectedly.
/// This usually means you are using a third-party storage system with an incorrect or incompatible implementation of the API it claims to support.
/// If so, this storage system is not suitable for use as a snapshot repository.
/// Repository analysis triggers conditions that occur only rarely when taking snapshots in a production system.
/// Snapshotting to unsuitable storage may appear to work correctly most of the time despite repository analysis failures.
/// However your snapshot data is at risk if you store it in a snapshot repository that does not reliably pass repository analysis.
/// You can demonstrate that the analysis failure is due to an incompatible storage implementation by verifying that Elasticsearch does not detect the same problem when analysing the reference implementation of the storage protocol you are using.
/// For instance, if you are using storage that offers an API which the supplier claims to be compatible with AWS S3, verify that repositories in AWS S3 do not fail repository analysis.
/// This allows you to demonstrate to your storage supplier that a repository analysis failure must only be caused by an incompatibility with AWS S3 and cannot be attributed to a problem in Elasticsearch.
/// Please do not report Elasticsearch issues involving third-party storage systems unless you can demonstrate that the same issue exists when analysing a repository that uses the reference implementation of the same storage protocol.
/// You will need to work with the supplier of your storage system to address the incompatibilities that Elasticsearch detects.
/// </para>
/// <para>
/// If the analysis is successful, the API returns details of the testing process, optionally including how long each operation took.
/// You can use this information to determine the performance of your storage system.
/// If any operation fails or returns an incorrect result, the API returns an error.
/// If the API returns an error, it may not have removed all the data it wrote to the repository.
/// The error will indicate the location of any leftover data and this path is also recorded in the Elasticsearch logs.
/// You should verify that this location has been cleaned up correctly.
/// If there is still leftover data at the specified location, you should manually remove it.
/// </para>
/// <para>
/// If the connection from your client to Elasticsearch is closed while the client is waiting for the result of the analysis, the test is cancelled.
/// Some clients are configured to close their connection if no response is received within a certain timeout.
/// An analysis takes a long time to complete so you might need to relax any such client-side timeouts.
/// On cancellation the analysis attempts to clean up the data it was writing, but it may not be able to remove it all.
/// The path to the leftover data is recorded in the Elasticsearch logs.
/// You should verify that this location has been cleaned up correctly.
/// If there is still leftover data at the specified location, you should manually remove it.
/// </para>
/// <para>
/// If the analysis is successful then it detected no incorrect behaviour, but this does not mean that correct behaviour is guaranteed.
/// The analysis attempts to detect common bugs but it does not offer 100% coverage.
/// Additionally, it does not test the following:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Your repository must perform durable writes. Once a blob has been written it must remain in place until it is deleted, even after a power loss or similar disaster.
/// </para>
/// </item>
/// <item>
/// <para>
/// Your repository must not suffer from silent data corruption. Once a blob has been written, its contents must remain unchanged until it is deliberately modified or deleted.
/// </para>
/// </item>
/// <item>
/// <para>
/// Your repository must behave correctly even if connectivity from the cluster is disrupted. Reads and writes may fail in this case, but they must not return incorrect results.
/// </para>
/// </item>
/// </list>
/// <para>
/// IMPORTANT: An analysis writes a substantial amount of data to your repository and then reads it back again.
/// This consumes bandwidth on the network between the cluster and the repository, and storage space and I/O bandwidth on the repository itself.
/// You must ensure this load does not affect other users of these systems.
/// Analyses respect the repository settings <c>max_snapshot_bytes_per_sec</c> and <c>max_restore_bytes_per_sec</c> if available and the cluster setting <c>indices.recovery.max_bytes_per_sec</c> which you can use to limit the bandwidth they consume.
/// </para>
/// <para>
/// NOTE: This API is intended for exploratory use by humans.
/// You should expect the request parameters and the response format to vary in future versions.
/// The response exposes immplementation details of the analysis which may change from version to version.
/// </para>
/// <para>
/// NOTE: Different versions of Elasticsearch may perform different checks for repository compatibility, with newer versions typically being stricter than older ones.
/// A storage system that passes repository analysis with one version of Elasticsearch may fail with a different version.
/// This indicates it behaves incorrectly in ways that the former version did not detect.
/// You must work with the supplier of your storage system to address the incompatibilities detected by the repository analysis API in any version of Elasticsearch.
/// </para>
/// <para>
/// NOTE: This API may not work correctly in a mixed-version cluster.
/// </para>
/// <para>
/// <em>Implementation details</em>
/// </para>
/// <para>
/// NOTE: This section of documentation describes how the repository analysis API works in this version of Elasticsearch, but you should expect the implementation to vary between versions.
/// The request parameters and response format depend on details of the implementation so may also be different in newer versions.
/// </para>
/// <para>
/// The analysis comprises a number of blob-level tasks, as set by the <c>blob_count</c> parameter and a number of compare-and-exchange operations on linearizable registers, as set by the <c>register_operation_count</c> parameter.
/// These tasks are distributed over the data and master-eligible nodes in the cluster for execution.
/// </para>
/// <para>
/// For most blob-level tasks, the executing node first writes a blob to the repository and then instructs some of the other nodes in the cluster to attempt to read the data it just wrote.
/// The size of the blob is chosen randomly, according to the <c>max_blob_size</c> and <c>max_total_data_size</c> parameters.
/// If any of these reads fails then the repository does not implement the necessary read-after-write semantics that Elasticsearch requires.
/// </para>
/// <para>
/// For some blob-level tasks, the executing node will instruct some of its peers to attempt to read the data before the writing process completes.
/// These reads are permitted to fail, but must not return partial data.
/// If any read returns partial data then the repository does not implement the necessary atomicity semantics that Elasticsearch requires.
/// </para>
/// <para>
/// For some blob-level tasks, the executing node will overwrite the blob while its peers are reading it.
/// In this case the data read may come from either the original or the overwritten blob, but the read operation must not return partial data or a mix of data from the two blobs.
/// If any of these reads returns partial data or a mix of the two blobs then the repository does not implement the necessary atomicity semantics that Elasticsearch requires for overwrites.
/// </para>
/// <para>
/// The executing node will use a variety of different methods to write the blob.
/// For instance, where applicable, it will use both single-part and multi-part uploads.
/// Similarly, the reading nodes will use a variety of different methods to read the data back again.
/// For instance they may read the entire blob from start to end or may read only a subset of the data.
/// </para>
/// <para>
/// For some blob-level tasks, the executing node will cancel the write before it is complete.
/// In this case, it still instructs some of the other nodes in the cluster to attempt to read the blob but all of these reads must fail to find the blob.
/// </para>
/// <para>
/// Linearizable registers are special blobs that Elasticsearch manipulates using an atomic compare-and-exchange operation.
/// This operation ensures correct and strongly-consistent behavior even when the blob is accessed by multiple nodes at the same time.
/// The detailed implementation of the compare-and-exchange operation on linearizable registers varies by repository type.
/// Repository analysis verifies that that uncontended compare-and-exchange operations on a linearizable register blob always succeed.
/// Repository analysis also verifies that contended operations either succeed or report the contention but do not return incorrect results.
/// If an operation fails due to contention, Elasticsearch retries the operation until it succeeds.
/// Most of the compare-and-exchange operations performed by repository analysis atomically increment a counter which is represented as an 8-byte blob.
/// Some operations also verify the behavior on small blobs with sizes other than 8 bytes.
/// </para>
/// </summary>
public readonly partial struct RepositoryAnalyzeRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RepositoryAnalyzeRequestDescriptor(Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest instance)
	{
		Instance = instance;
	}

	public RepositoryAnalyzeRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public RepositoryAnalyzeRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor(Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest instance) => new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest(Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the repository.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The total number of blobs to write to the repository during the test.
	/// For realistic experiments, you should set it to at least <c>2000</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor BlobCount(int? value)
	{
		Instance.BlobCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of operations to run concurrently during the test.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor Concurrency(int? value)
	{
		Instance.Concurrency = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to return detailed results, including timing information for every operation performed during the analysis.
	/// If false, it returns only a summary of the analysis.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor Detailed(bool? value = true)
	{
		Instance.Detailed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of nodes on which to perform an early read operation while writing each blob.
	/// Early read operations are only rarely performed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor EarlyReadNodeCount(int? value)
	{
		Instance.EarlyReadNodeCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum size of a blob to be written during the test.
	/// For realistic experiments, you should set it to at least <c>2gb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor MaxBlobSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxBlobSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum size of a blob to be written during the test.
	/// For realistic experiments, you should set it to at least <c>2gb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor MaxBlobSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxBlobSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An upper limit on the total size of all the blobs written during the test.
	/// For realistic experiments, you should set it to at least <c>1tb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor MaxTotalDataSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxTotalDataSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An upper limit on the total size of all the blobs written during the test.
	/// For realistic experiments, you should set it to at least <c>1tb</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor MaxTotalDataSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxTotalDataSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The probability of performing a rare action such as an early read, an overwrite, or an aborted write on each blob.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor RareActionProbability(double? value)
	{
		Instance.RareActionProbability = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates whether to rarely cancel writes before they complete.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor RarelyAbortWrites(bool? value = true)
	{
		Instance.RarelyAbortWrites = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of nodes on which to read a blob after writing.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor ReadNodeCount(int? value)
	{
		Instance.ReadNodeCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum number of linearizable register operations to perform in total.
	/// For realistic experiments, you should set it to at least <c>100</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor RegisterOperationCount(int? value)
	{
		Instance.RegisterOperationCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The seed for the pseudo-random number generator used to generate the list of operations performed during the test.
	/// To repeat the same set of operations in multiple experiments, use the same seed in each experiment.
	/// Note that the operations are performed concurrently so might not always happen in the same order on each run.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor Seed(int? value)
	{
		Instance.Seed = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period of time to wait for the test to complete.
	/// If no response is received before the timeout expires, the test is cancelled and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.RepositoryAnalyzeRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}