// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Snapshot;

public sealed partial class CreateRepositoryRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response from all relevant nodes in the cluster after updating the cluster metadata.
	/// If no response is received before the timeout expires, the cluster metadata update still applies but the response will indicate that it was not completely acknowledged.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request verifies the repository is functional on all master and data nodes in the cluster.
	/// If <c>false</c>, this verification is skipped.
	/// You can also perform this verification with the verify snapshot repository API.
	/// </para>
	/// </summary>
	public bool? Verify { get => Q<bool?>("verify"); set => Q("verify", value); }
}

/// <summary>
/// <para>
/// Create or update a snapshot repository.
/// IMPORTANT: If you are migrating searchable snapshots, the repository name must be identical in the source and destination clusters.
/// To register a snapshot repository, the cluster's global metadata must be writeable.
/// Ensure there are no cluster blocks (for example, <c>cluster.blocks.read_only</c> and <c>clsuter.blocks.read_only_allow_delete</c> settings) that prevent write access.
/// </para>
/// <para>
/// Several options for this API can be specified using a query parameter or a request body parameter.
/// If both parameters are specified, only the query parameter is used.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Snapshot.Json.CreateRepositoryRequestConverter))]
public sealed partial class CreateRepositoryRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateRepositoryRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("repository", name))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateRepositoryRequest(Elastic.Clients.Elasticsearch.Name name, Elastic.Clients.Elasticsearch.Snapshot.IRepository repository) : base(r => r.Required("repository", name))
	{
		Repository = repository;
	}
#if NET7_0_OR_GREATER
	public CreateRepositoryRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CreateRepositoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SnapshotCreateRepository;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "snapshot.create_repository";

	/// <summary>
	/// <para>
	/// The name of the snapshot repository to register or update.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("repository"); set => PR("repository", value); }

	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response from all relevant nodes in the cluster after updating the cluster metadata.
	/// If no response is received before the timeout expires, the cluster metadata update still applies but the response will indicate that it was not completely acknowledged.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request verifies the repository is functional on all master and data nodes in the cluster.
	/// If <c>false</c>, this verification is skipped.
	/// You can also perform this verification with the verify snapshot repository API.
	/// </para>
	/// </summary>
	public bool? Verify { get => Q<bool?>("verify"); set => Q("verify", value); }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Snapshot.IRepository Repository { get; set; }
}

/// <summary>
/// <para>
/// Create or update a snapshot repository.
/// IMPORTANT: If you are migrating searchable snapshots, the repository name must be identical in the source and destination clusters.
/// To register a snapshot repository, the cluster's global metadata must be writeable.
/// Ensure there are no cluster blocks (for example, <c>cluster.blocks.read_only</c> and <c>clsuter.blocks.read_only_allow_delete</c> settings) that prevent write access.
/// </para>
/// <para>
/// Several options for this API can be specified using a query parameter or a request body parameter.
/// If both parameters are specified, only the query parameter is used.
/// </para>
/// </summary>
public readonly partial struct CreateRepositoryRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateRepositoryRequestDescriptor(Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest instance)
	{
		Instance = instance;
	}

	public CreateRepositoryRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest(name);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public CreateRepositoryRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor(Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest instance) => new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest(Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the snapshot repository to register or update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for the master node.
	/// If the master node is not available before the timeout expires, the request fails and returns an error.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response from all relevant nodes in the cluster after updating the cluster metadata.
	/// If no response is received before the timeout expires, the cluster metadata update still applies but the response will indicate that it was not completely acknowledged.
	/// To indicate that the request should never timeout, set it to <c>-1</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the request verifies the repository is functional on all master and data nodes in the cluster.
	/// If <c>false</c>, this verification is skipped.
	/// You can also perform this verification with the verify snapshot repository API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor Verify(bool? value = true)
	{
		Instance.Verify = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor Repository(Elastic.Clients.Elasticsearch.Snapshot.IRepository value)
	{
		Instance.Repository = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor Repository(System.Func<Elastic.Clients.Elasticsearch.Snapshot.RepositoryFactory, Elastic.Clients.Elasticsearch.Snapshot.IRepository> action)
	{
		Instance.Repository = Elastic.Clients.Elasticsearch.Snapshot.RepositoryFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest Build(System.Action<Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor(new Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Snapshot.CreateRepositoryRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}