// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Simulate;

public sealed partial class IngestRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The pipeline to use as the default pipeline.
	/// This value can be used to override the default pipeline of the index.
	/// </para>
	/// </summary>
	public string? Pipeline { get => Q<string?>("pipeline"); set => Q("pipeline", value); }
}

/// <summary>
/// <para>
/// Simulate data ingestion.
/// Run ingest pipelines against a set of provided documents, optionally with substitute pipeline definitions, to simulate ingesting data into an index.
/// </para>
/// <para>
/// This API is meant to be used for troubleshooting or pipeline development, as it does not actually index any data into Elasticsearch.
/// </para>
/// <para>
/// The API runs the default and final pipeline for that index against a set of documents provided in the body of the request.
/// If a pipeline contains a reroute processor, it follows that reroute processor to the new index, running that index's pipelines as well the same way that a non-simulated ingest would.
/// No data is indexed into Elasticsearch.
/// Instead, the transformed document is returned, along with the list of pipelines that have been run and the name of the index where the document would have been indexed if this were not a simulation.
/// The transformed document is validated against the mappings that would apply to this index, and any validation error is reported in the result.
/// </para>
/// <para>
/// This API differs from the simulate pipeline API in that you specify a single pipeline for that API, and it runs only that one pipeline.
/// The simulate pipeline API is more useful for developing a single pipeline, while the simulate ingest API is more useful for troubleshooting the interaction of the various pipelines that get applied when ingesting into an index.
/// </para>
/// <para>
/// By default, the pipeline definitions that are currently in the system are used.
/// However, you can supply substitute pipeline definitions in the body of the request.
/// These will be used in place of the pipeline definitions that are already in the system. This can be used to replace existing pipeline definitions or to create new ones. The pipeline substitutions are used only within this request.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Simulate.Json.IngestRequestConverter))]
public sealed partial class IngestRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Simulate.IngestRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IngestRequest(Elastic.Clients.Elasticsearch.IndexName? index) : base(r => r.Optional("index", index))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IngestRequest(Elastic.Clients.Elasticsearch.IndexName? index, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> docs) : base(r => r.Optional("index", index))
	{
		Docs = docs;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IngestRequest(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> docs)
	{
		Docs = docs;
	}
#if NET7_0_OR_GREATER
	public IngestRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IngestRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IngestRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SimulateIngest;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "simulate.ingest";

	/// <summary>
	/// <para>
	/// The index to simulate ingesting into.
	/// This value can be overridden by specifying an index on each document.
	/// If you specify this parameter in the request path, it is used for any documents that do not explicitly specify an index argument.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get => P<Elastic.Clients.Elasticsearch.IndexName?>("index"); set => PO("index", value); }

	/// <summary>
	/// <para>
	/// The pipeline to use as the default pipeline.
	/// This value can be used to override the default pipeline of the index.
	/// </para>
	/// </summary>
	public string? Pipeline { get => Q<string?>("pipeline"); set => Q("pipeline", value); }

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>? ComponentTemplateSubstitutions { get; set; }

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> Docs { get; set; }

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>? IndexTemplateSubstitutions { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.TypeMapping? MappingAddition { get; set; }

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>? PipelineSubstitutions { get; set; }
}

/// <summary>
/// <para>
/// Simulate data ingestion.
/// Run ingest pipelines against a set of provided documents, optionally with substitute pipeline definitions, to simulate ingesting data into an index.
/// </para>
/// <para>
/// This API is meant to be used for troubleshooting or pipeline development, as it does not actually index any data into Elasticsearch.
/// </para>
/// <para>
/// The API runs the default and final pipeline for that index against a set of documents provided in the body of the request.
/// If a pipeline contains a reroute processor, it follows that reroute processor to the new index, running that index's pipelines as well the same way that a non-simulated ingest would.
/// No data is indexed into Elasticsearch.
/// Instead, the transformed document is returned, along with the list of pipelines that have been run and the name of the index where the document would have been indexed if this were not a simulation.
/// The transformed document is validated against the mappings that would apply to this index, and any validation error is reported in the result.
/// </para>
/// <para>
/// This API differs from the simulate pipeline API in that you specify a single pipeline for that API, and it runs only that one pipeline.
/// The simulate pipeline API is more useful for developing a single pipeline, while the simulate ingest API is more useful for troubleshooting the interaction of the various pipelines that get applied when ingesting into an index.
/// </para>
/// <para>
/// By default, the pipeline definitions that are currently in the system are used.
/// However, you can supply substitute pipeline definitions in the body of the request.
/// These will be used in place of the pipeline definitions that are already in the system. This can be used to replace existing pipeline definitions or to create new ones. The pipeline substitutions are used only within this request.
/// </para>
/// </summary>
public readonly partial struct IngestRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Simulate.IngestRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IngestRequestDescriptor(Elastic.Clients.Elasticsearch.Simulate.IngestRequest instance)
	{
		Instance = instance;
	}

	public IngestRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName? index)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Simulate.IngestRequest(index);
#pragma warning restore CS0618
	}

	public IngestRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Simulate.IngestRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor(Elastic.Clients.Elasticsearch.Simulate.IngestRequest instance) => new Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Simulate.IngestRequest(Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The index to simulate ingesting into.
	/// This value can be overridden by specifying an index on each document.
	/// If you specify this parameter in the request path, it is used for any documents that do not explicitly specify an index argument.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to use as the default pipeline.
	/// This value can be used to override the default pipeline of the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor Pipeline(string? value)
	{
		Instance.Pipeline = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor ComponentTemplateSubstitutions(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>? value)
	{
		Instance.ComponentTemplateSubstitutions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor ComponentTemplateSubstitutions()
	{
		Instance.ComponentTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor ComponentTemplateSubstitutions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode>? action)
	{
		Instance.ComponentTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor ComponentTemplateSubstitutions<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode<T>>? action)
	{
		Instance.ComponentTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddComponentTemplateSubstitution(string key, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode value)
	{
		Instance.ComponentTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>();
		Instance.ComponentTemplateSubstitutions.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddComponentTemplateSubstitution(string key, System.Action<Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNodeDescriptor> action)
	{
		Instance.ComponentTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>();
		Instance.ComponentTemplateSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNodeDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddComponentTemplateSubstitution<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNodeDescriptor<T>> action)
	{
		Instance.ComponentTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>();
		Instance.ComponentTemplateSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNodeDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor Docs(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> value)
	{
		Instance.Docs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor Docs(params Elastic.Clients.Elasticsearch.Ingest.Document[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor Docs(params System.Action<Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Document>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor IndexTemplateSubstitutions(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>? value)
	{
		Instance.IndexTemplateSubstitutions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor IndexTemplateSubstitutions()
	{
		Instance.IndexTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor IndexTemplateSubstitutions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate>? action)
	{
		Instance.IndexTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor IndexTemplateSubstitutions<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate<T>>? action)
	{
		Instance.IndexTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddIndexTemplateSubstitution(string key, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate value)
	{
		Instance.IndexTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>();
		Instance.IndexTemplateSubstitutions.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddIndexTemplateSubstitution(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor> action)
	{
		Instance.IndexTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>();
		Instance.IndexTemplateSubstitutions.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddIndexTemplateSubstitution<T>(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<T>> action)
	{
		Instance.IndexTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>();
		Instance.IndexTemplateSubstitutions.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<T>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor MappingAddition(Elastic.Clients.Elasticsearch.Mapping.TypeMapping? value)
	{
		Instance.MappingAddition = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor MappingAddition()
	{
		Instance.MappingAddition = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor MappingAddition(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor>? action)
	{
		Instance.MappingAddition = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor MappingAddition<T>(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<T>>? action)
	{
		Instance.MappingAddition = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor PipelineSubstitutions(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>? value)
	{
		Instance.PipelineSubstitutions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor PipelineSubstitutions()
	{
		Instance.PipelineSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor PipelineSubstitutions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline>? action)
	{
		Instance.PipelineSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor PipelineSubstitutions<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline<T>>? action)
	{
		Instance.PipelineSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddPipelineSubstitution(string key, Elastic.Clients.Elasticsearch.Ingest.Pipeline value)
	{
		Instance.PipelineSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		Instance.PipelineSubstitutions.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor PipelineSubstitutions(string key)
	{
		Instance.PipelineSubstitutions = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline> { { key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor PipelineSubstitutions(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor.Build(null));
		}

		Instance.PipelineSubstitutions = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddPipelineSubstitution(string key)
	{
		Instance.PipelineSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		Instance.PipelineSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddPipelineSubstitution(string key, System.Action<Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor>? action)
	{
		Instance.PipelineSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		Instance.PipelineSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor AddPipelineSubstitution<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<T>>? action)
	{
		Instance.PipelineSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		Instance.PipelineSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Simulate.IngestRequest Build(System.Action<Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor(new Elastic.Clients.Elasticsearch.Simulate.IngestRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Simulate data ingestion.
/// Run ingest pipelines against a set of provided documents, optionally with substitute pipeline definitions, to simulate ingesting data into an index.
/// </para>
/// <para>
/// This API is meant to be used for troubleshooting or pipeline development, as it does not actually index any data into Elasticsearch.
/// </para>
/// <para>
/// The API runs the default and final pipeline for that index against a set of documents provided in the body of the request.
/// If a pipeline contains a reroute processor, it follows that reroute processor to the new index, running that index's pipelines as well the same way that a non-simulated ingest would.
/// No data is indexed into Elasticsearch.
/// Instead, the transformed document is returned, along with the list of pipelines that have been run and the name of the index where the document would have been indexed if this were not a simulation.
/// The transformed document is validated against the mappings that would apply to this index, and any validation error is reported in the result.
/// </para>
/// <para>
/// This API differs from the simulate pipeline API in that you specify a single pipeline for that API, and it runs only that one pipeline.
/// The simulate pipeline API is more useful for developing a single pipeline, while the simulate ingest API is more useful for troubleshooting the interaction of the various pipelines that get applied when ingesting into an index.
/// </para>
/// <para>
/// By default, the pipeline definitions that are currently in the system are used.
/// However, you can supply substitute pipeline definitions in the body of the request.
/// These will be used in place of the pipeline definitions that are already in the system. This can be used to replace existing pipeline definitions or to create new ones. The pipeline substitutions are used only within this request.
/// </para>
/// </summary>
public readonly partial struct IngestRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Simulate.IngestRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IngestRequestDescriptor(Elastic.Clients.Elasticsearch.Simulate.IngestRequest instance)
	{
		Instance = instance;
	}

	public IngestRequestDescriptor(Elastic.Clients.Elasticsearch.IndexName? index)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Simulate.IngestRequest(index);
#pragma warning restore CS0618
	}

	public IngestRequestDescriptor()
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Simulate.IngestRequest(typeof(TDocument));
#pragma warning restore CS0618
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Simulate.IngestRequest instance) => new Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Simulate.IngestRequest(Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The index to simulate ingesting into.
	/// This value can be overridden by specifying an index on each document.
	/// If you specify this parameter in the request path, it is used for any documents that do not explicitly specify an index argument.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The pipeline to use as the default pipeline.
	/// This value can be used to override the default pipeline of the index.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> Pipeline(string? value)
	{
		Instance.Pipeline = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> ComponentTemplateSubstitutions(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>? value)
	{
		Instance.ComponentTemplateSubstitutions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> ComponentTemplateSubstitutions()
	{
		Instance.ComponentTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of component template names to substitute component template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> ComponentTemplateSubstitutions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode<TDocument>>? action)
	{
		Instance.ComponentTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringComponentTemplateNode<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> AddComponentTemplateSubstitution(string key, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode value)
	{
		Instance.ComponentTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>();
		Instance.ComponentTemplateSubstitutions.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> AddComponentTemplateSubstitution(string key, System.Action<Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNodeDescriptor<TDocument>> action)
	{
		Instance.ComponentTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>();
		Instance.ComponentTemplateSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNodeDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> Docs(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> value)
	{
		Instance.Docs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> Docs(params Elastic.Clients.Elasticsearch.Ingest.Document[] values)
	{
		Instance.Docs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Sample documents to test in the pipeline.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> Docs(params System.Action<Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Ingest.Document>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Ingest.DocumentDescriptor.Build(action));
		}

		Instance.Docs = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> IndexTemplateSubstitutions(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>? value)
	{
		Instance.IndexTemplateSubstitutions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> IndexTemplateSubstitutions()
	{
		Instance.IndexTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A map of index template names to substitute index template definition objects.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> IndexTemplateSubstitutions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate<TDocument>>? action)
	{
		Instance.IndexTemplateSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringIndexTemplate<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> AddIndexTemplateSubstitution(string key, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate value)
	{
		Instance.IndexTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>();
		Instance.IndexTemplateSubstitutions.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> AddIndexTemplateSubstitution(string key, System.Action<Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>> action)
	{
		Instance.IndexTemplateSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>();
		Instance.IndexTemplateSubstitutions.Add(key, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplateDescriptor<TDocument>.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> MappingAddition(Elastic.Clients.Elasticsearch.Mapping.TypeMapping? value)
	{
		Instance.MappingAddition = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> MappingAddition()
	{
		Instance.MappingAddition = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>.Build(null);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> MappingAddition(System.Action<Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>>? action)
	{
		Instance.MappingAddition = Elastic.Clients.Elasticsearch.Mapping.TypeMappingDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> PipelineSubstitutions(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>? value)
	{
		Instance.PipelineSubstitutions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> PipelineSubstitutions()
	{
		Instance.PipelineSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> PipelineSubstitutions(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline<TDocument>>? action)
	{
		Instance.PipelineSubstitutions = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringPipeline<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> AddPipelineSubstitution(string key, Elastic.Clients.Elasticsearch.Ingest.Pipeline value)
	{
		Instance.PipelineSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		Instance.PipelineSubstitutions.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> PipelineSubstitutions(string key)
	{
		Instance.PipelineSubstitutions = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline> { { key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// Pipelines to test.
	/// If you don’t specify the <c>pipeline</c> request path parameter, this parameter is required.
	/// If you specify both this and the request path parameter, the API only uses the request path parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> PipelineSubstitutions(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>.Build(null));
		}

		Instance.PipelineSubstitutions = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> AddPipelineSubstitution(string key)
	{
		Instance.PipelineSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		Instance.PipelineSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> AddPipelineSubstitution(string key, System.Action<Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>>? action)
	{
		Instance.PipelineSubstitutions ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>();
		Instance.PipelineSubstitutions.Add(key, Elastic.Clients.Elasticsearch.Ingest.PipelineDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Simulate.IngestRequest Build(System.Action<Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Simulate.IngestRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Simulate.IngestRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}