// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Simulate.Json;

public sealed partial class IngestRequestConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Simulate.IngestRequest>
{
	private static readonly System.Text.Json.JsonEncodedText PropComponentTemplateSubstitutions = System.Text.Json.JsonEncodedText.Encode("component_template_substitutions");
	private static readonly System.Text.Json.JsonEncodedText PropDocs = System.Text.Json.JsonEncodedText.Encode("docs");
	private static readonly System.Text.Json.JsonEncodedText PropIndexTemplateSubstitutions = System.Text.Json.JsonEncodedText.Encode("index_template_substitutions");
	private static readonly System.Text.Json.JsonEncodedText PropMappingAddition = System.Text.Json.JsonEncodedText.Encode("mapping_addition");
	private static readonly System.Text.Json.JsonEncodedText PropPipelineSubstitutions = System.Text.Json.JsonEncodedText.Encode("pipeline_substitutions");

	public override Elastic.Clients.Elasticsearch.Simulate.IngestRequest Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>?> propComponentTemplateSubstitutions = default;
		LocalJsonValue<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document>> propDocs = default;
		LocalJsonValue<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>?> propIndexTemplateSubstitutions = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Mapping.TypeMapping?> propMappingAddition = default;
		LocalJsonValue<System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>?> propPipelineSubstitutions = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propComponentTemplateSubstitutions.TryReadProperty(ref reader, options, PropComponentTemplateSubstitutions, static System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>(o, null, null)))
			{
				continue;
			}

			if (propDocs.TryReadProperty(ref reader, options, PropDocs, static System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Ingest.Document>(o, null)!))
			{
				continue;
			}

			if (propIndexTemplateSubstitutions.TryReadProperty(ref reader, options, PropIndexTemplateSubstitutions, static System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>(o, null, null)))
			{
				continue;
			}

			if (propMappingAddition.TryReadProperty(ref reader, options, PropMappingAddition, null))
			{
				continue;
			}

			if (propPipelineSubstitutions.TryReadProperty(ref reader, options, PropPipelineSubstitutions, static System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>(o, null, null)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Simulate.IngestRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ComponentTemplateSubstitutions = propComponentTemplateSubstitutions.Value,
			Docs = propDocs.Value,
			IndexTemplateSubstitutions = propIndexTemplateSubstitutions.Value,
			MappingAddition = propMappingAddition.Value,
			PipelineSubstitutions = propPipelineSubstitutions.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Simulate.IngestRequest value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropComponentTemplateSubstitutions, value.ComponentTemplateSubstitutions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Cluster.ComponentTemplateNode>(o, v, null, null));
		writer.WriteProperty(options, PropDocs, value.Docs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Ingest.Document> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Ingest.Document>(o, v, null));
		writer.WriteProperty(options, PropIndexTemplateSubstitutions, value.IndexTemplateSubstitutions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.IndexManagement.IndexTemplate>(o, v, null, null));
		writer.WriteProperty(options, PropMappingAddition, value.MappingAddition, null, null);
		writer.WriteProperty(options, PropPipelineSubstitutions, value.PipelineSubstitutions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Ingest.Pipeline>(o, v, null, null));
		writer.WriteEndObject();
	}
}