// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class UpdateUserProfileDataRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Only perform the operation if the document has this primary term.
	/// </para>
	/// </summary>
	public long? IfPrimaryTerm { get => Q<long?>("if_primary_term"); set => Q("if_primary_term", value); }

	/// <summary>
	/// <para>
	/// Only perform the operation if the document has this sequence number.
	/// </para>
	/// </summary>
	public long? IfSeqNo { get => Q<long?>("if_seq_no"); set => Q("if_seq_no", value); }

	/// <summary>
	/// <para>
	/// If 'true', Elasticsearch refreshes the affected shards to make this operation
	/// visible to search.
	/// If 'wait_for', it waits for a refresh to make this operation visible to search.
	/// If 'false', nothing is done with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Update user profile data.
/// </para>
/// <para>
/// Update specific data for the user profile that is associated with a unique ID.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions.
/// Individual users and external applications should not call this API directly.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// <para>
/// To use this API, you must have one of the following privileges:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// The <c>manage_user_profile</c> cluster privilege.
/// </para>
/// </item>
/// <item>
/// <para>
/// The <c>update_profile_data</c> global privilege for the namespaces that are referenced in the request.
/// </para>
/// </item>
/// </list>
/// <para>
/// This API updates the <c>labels</c> and <c>data</c> fields of an existing user profile document with JSON objects.
/// New keys and their values are added to the profile document and conflicting keys are replaced by data that's included in the request.
/// </para>
/// <para>
/// For both labels and data, content is namespaced by the top-level fields.
/// The <c>update_profile_data</c> global privilege grants privileges for updating only the allowed namespaces.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.UpdateUserProfileDataRequestConverter))]
public sealed partial class UpdateUserProfileDataRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateUserProfileDataRequest(string uid) : base(r => r.Required("uid", uid))
	{
	}
#if NET7_0_OR_GREATER
	public UpdateUserProfileDataRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateUserProfileDataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityUpdateUserProfileData;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.update_user_profile_data";

	/// <summary>
	/// <para>
	/// A unique identifier for the user profile.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Uid { get => P<string>("uid"); set => PR("uid", value); }

	/// <summary>
	/// <para>
	/// Only perform the operation if the document has this primary term.
	/// </para>
	/// </summary>
	public long? IfPrimaryTerm { get => Q<long?>("if_primary_term"); set => Q("if_primary_term", value); }

	/// <summary>
	/// <para>
	/// Only perform the operation if the document has this sequence number.
	/// </para>
	/// </summary>
	public long? IfSeqNo { get => Q<long?>("if_seq_no"); set => Q("if_seq_no", value); }

	/// <summary>
	/// <para>
	/// If 'true', Elasticsearch refreshes the affected shards to make this operation
	/// visible to search.
	/// If 'wait_for', it waits for a refresh to make this operation visible to search.
	/// If 'false', nothing is done with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// Non-searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the <c>data</c> object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// The data object is not searchable, but can be retrieved with the get user profile API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Data { get; set; }

	/// <summary>
	/// <para>
	/// Searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the labels object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Labels { get; set; }
}

/// <summary>
/// <para>
/// Update user profile data.
/// </para>
/// <para>
/// Update specific data for the user profile that is associated with a unique ID.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions.
/// Individual users and external applications should not call this API directly.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// <para>
/// To use this API, you must have one of the following privileges:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// The <c>manage_user_profile</c> cluster privilege.
/// </para>
/// </item>
/// <item>
/// <para>
/// The <c>update_profile_data</c> global privilege for the namespaces that are referenced in the request.
/// </para>
/// </item>
/// </list>
/// <para>
/// This API updates the <c>labels</c> and <c>data</c> fields of an existing user profile document with JSON objects.
/// New keys and their values are added to the profile document and conflicting keys are replaced by data that's included in the request.
/// </para>
/// <para>
/// For both labels and data, content is namespaced by the top-level fields.
/// The <c>update_profile_data</c> global privilege grants privileges for updating only the allowed namespaces.
/// </para>
/// </summary>
public readonly partial struct UpdateUserProfileDataRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateUserProfileDataRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest instance)
	{
		Instance = instance;
	}

	public UpdateUserProfileDataRequestDescriptor(string uid)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest(uid);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateUserProfileDataRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest instance) => new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest(Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A unique identifier for the user profile.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Uid(string value)
	{
		Instance.Uid = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only perform the operation if the document has this primary term.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor IfPrimaryTerm(long? value)
	{
		Instance.IfPrimaryTerm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Only perform the operation if the document has this sequence number.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor IfSeqNo(long? value)
	{
		Instance.IfSeqNo = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If 'true', Elasticsearch refreshes the affected shards to make this operation
	/// visible to search.
	/// If 'wait_for', it waits for a refresh to make this operation visible to search.
	/// If 'false', nothing is done with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Non-searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the <c>data</c> object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// The data object is not searchable, but can be retrieved with the get user profile API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Data(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Data = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Non-searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the <c>data</c> object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// The data object is not searchable, but can be retrieved with the get user profile API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Data()
	{
		Instance.Data = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Non-searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the <c>data</c> object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// The data object is not searchable, but can be retrieved with the get user profile API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Data(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Data = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor AddDatum(string key, object value)
	{
		Instance.Data ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Data.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// Searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the labels object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Labels(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Labels = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the labels object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Labels()
	{
		Instance.Labels = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Searchable data that you want to associate with the user profile.
	/// This field supports a nested data structure.
	/// Within the labels object, top-level keys cannot begin with an underscore (<c>_</c>) or contain a period (<c>.</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Labels(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Labels = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor AddLabel(string key, object value)
	{
		Instance.Labels ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Labels.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateUserProfileDataRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}