// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class UpdateSettingsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }
}

/// <summary>
/// <para>
/// Update security index settings.
/// </para>
/// <para>
/// Update the user-configurable settings for the security internal index (<c>.security</c> and associated indices). Only a subset of settings are allowed to be modified. This includes <c>index.auto_expand_replicas</c> and <c>index.number_of_replicas</c>.
/// </para>
/// <para>
/// NOTE: If <c>index.auto_expand_replicas</c> is set, <c>index.number_of_replicas</c> will be ignored during updates.
/// </para>
/// <para>
/// If a specific index is not in use on the system and settings are provided for it, the request will be rejected.
/// This API does not yet support configuring the settings for indices before they are in use.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.UpdateSettingsRequestConverter))]
public sealed partial class UpdateSettingsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestParameters>
{
#if NET7_0_OR_GREATER
	public UpdateSettingsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public UpdateSettingsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityUpdateSettings;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.update_settings";

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MasterTimeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("master_timeout"); set => Q("master_timeout", value); }

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get => Q<Elastic.Clients.Elasticsearch.Duration?>("timeout"); set => Q("timeout", value); }

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SecuritySettings? Security { get; set; }

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SecuritySettings? SecurityProfile { get; set; }

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SecuritySettings? SecurityTokens { get; set; }
}

/// <summary>
/// <para>
/// Update security index settings.
/// </para>
/// <para>
/// Update the user-configurable settings for the security internal index (<c>.security</c> and associated indices). Only a subset of settings are allowed to be modified. This includes <c>index.auto_expand_replicas</c> and <c>index.number_of_replicas</c>.
/// </para>
/// <para>
/// NOTE: If <c>index.auto_expand_replicas</c> is set, <c>index.number_of_replicas</c> will be ignored during updates.
/// </para>
/// <para>
/// If a specific index is not in use on the system and settings are provided for it, the request will be rejected.
/// This API does not yet support configuring the settings for indices before they are in use.
/// </para>
/// </summary>
public readonly partial struct UpdateSettingsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest instance)
	{
		Instance = instance;
	}

	public UpdateSettingsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest instance) => new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor Security(Elastic.Clients.Elasticsearch.Security.SecuritySettings? value)
	{
		Instance.Security = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor Security()
	{
		Instance.Security = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor Security(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor>? action)
	{
		Instance.Security = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor Security<T>(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<T>>? action)
	{
		Instance.Security = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityProfile(Elastic.Clients.Elasticsearch.Security.SecuritySettings? value)
	{
		Instance.SecurityProfile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityProfile()
	{
		Instance.SecurityProfile = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityProfile(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor>? action)
	{
		Instance.SecurityProfile = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityProfile<T>(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<T>>? action)
	{
		Instance.SecurityProfile = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityTokens(Elastic.Clients.Elasticsearch.Security.SecuritySettings? value)
	{
		Instance.SecurityTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityTokens()
	{
		Instance.SecurityTokens = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityTokens(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor>? action)
	{
		Instance.SecurityTokens = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SecurityTokens<T>(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<T>>? action)
	{
		Instance.SecurityTokens = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Update security index settings.
/// </para>
/// <para>
/// Update the user-configurable settings for the security internal index (<c>.security</c> and associated indices). Only a subset of settings are allowed to be modified. This includes <c>index.auto_expand_replicas</c> and <c>index.number_of_replicas</c>.
/// </para>
/// <para>
/// NOTE: If <c>index.auto_expand_replicas</c> is set, <c>index.number_of_replicas</c> will be ignored during updates.
/// </para>
/// <para>
/// If a specific index is not in use on the system and settings are provided for it, the request will be rejected.
/// This API does not yet support configuring the settings for indices before they are in use.
/// </para>
/// </summary>
public readonly partial struct UpdateSettingsRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateSettingsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest instance)
	{
		Instance = instance;
	}

	public UpdateSettingsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest instance) => new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The period to wait for a connection to the master node.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> MasterTimeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MasterTimeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The period to wait for a response.
	/// If no response is received before the timeout expires, the request fails and returns an error.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> Security(Elastic.Clients.Elasticsearch.Security.SecuritySettings? value)
	{
		Instance.Security = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> Security()
	{
		Instance.Security = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used for most security configuration, including native realm users and roles configured with the API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> Security(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>>? action)
	{
		Instance.Security = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> SecurityProfile(Elastic.Clients.Elasticsearch.Security.SecuritySettings? value)
	{
		Instance.SecurityProfile = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> SecurityProfile()
	{
		Instance.SecurityProfile = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store profile information.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> SecurityProfile(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>>? action)
	{
		Instance.SecurityProfile = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> SecurityTokens(Elastic.Clients.Elasticsearch.Security.SecuritySettings? value)
	{
		Instance.SecurityTokens = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> SecurityTokens()
	{
		Instance.SecurityTokens = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Settings for the index used to store tokens.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> SecurityTokens(System.Action<Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>>? action)
	{
		Instance.SecurityTokens = Elastic.Clients.Elasticsearch.Security.SecuritySettingsDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateSettingsRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}