// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class UpdateCrossClusterApiKeyRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Update a cross-cluster API key.
/// </para>
/// <para>
/// Update the attributes of an existing cross-cluster API key, which is used for API key based remote cluster access.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_security</c> cluster privilege.
/// Users can only update API keys that they created.
/// To update another user's API key, use the <c>run_as</c> feature to submit a request on behalf of another user.
/// </para>
/// <para>
/// IMPORTANT: It's not possible to use an API key as the authentication credential for this API.
/// To update an API key, the owner user's credentials are required.
/// </para>
/// <para>
/// It's not possible to update expired API keys, or API keys that have been invalidated by the invalidate API key API.
/// </para>
/// <para>
/// This API supports updates to an API key's access scope, metadata, and expiration.
/// The owner user's information, such as the <c>username</c> and <c>realm</c>, is also updated automatically on every call.
/// </para>
/// <para>
/// NOTE: This API cannot update REST API keys, which should be updated by either the update API key or bulk update API keys API.
/// </para>
/// <para>
/// To learn more about how to use this API, refer to the <a href="https://www.elastic.co/docs/reference/elasticsearch/rest-apis/update-cc-api-key-examples">Update cross cluter API key API examples page</a>.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.UpdateCrossClusterApiKeyRequestConverter))]
public sealed partial class UpdateCrossClusterApiKeyRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestParameters>
{
	[System.Obsolete("The request contains additional required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateCrossClusterApiKeyRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateCrossClusterApiKeyRequest(Elastic.Clients.Elasticsearch.Id id, Elastic.Clients.Elasticsearch.Security.Access access) : base(r => r.Required("id", id))
	{
		Access = access;
	}
#if NET7_0_OR_GREATER
	public UpdateCrossClusterApiKeyRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateCrossClusterApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityUpdateCrossClusterApiKey;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.update_cross_cluster_api_key";

	/// <summary>
	/// <para>
	/// The ID of the cross-cluster API key to update.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Security.Access Access { get; set; }

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire. This property can be omitted to leave the value unchanged.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Expiration { get; set; }

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this information fully replaces metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }
}

/// <summary>
/// <para>
/// Update a cross-cluster API key.
/// </para>
/// <para>
/// Update the attributes of an existing cross-cluster API key, which is used for API key based remote cluster access.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_security</c> cluster privilege.
/// Users can only update API keys that they created.
/// To update another user's API key, use the <c>run_as</c> feature to submit a request on behalf of another user.
/// </para>
/// <para>
/// IMPORTANT: It's not possible to use an API key as the authentication credential for this API.
/// To update an API key, the owner user's credentials are required.
/// </para>
/// <para>
/// It's not possible to update expired API keys, or API keys that have been invalidated by the invalidate API key API.
/// </para>
/// <para>
/// This API supports updates to an API key's access scope, metadata, and expiration.
/// The owner user's information, such as the <c>username</c> and <c>realm</c>, is also updated automatically on every call.
/// </para>
/// <para>
/// NOTE: This API cannot update REST API keys, which should be updated by either the update API key or bulk update API keys API.
/// </para>
/// <para>
/// To learn more about how to use this API, refer to the <a href="https://www.elastic.co/docs/reference/elasticsearch/rest-apis/update-cc-api-key-examples">Update cross cluter API key API examples page</a>.
/// </para>
/// </summary>
public readonly partial struct UpdateCrossClusterApiKeyRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateCrossClusterApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest instance)
	{
		Instance = instance;
	}

	public UpdateCrossClusterApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest(id);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateCrossClusterApiKeyRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the cross-cluster API key to update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Access(Elastic.Clients.Elasticsearch.Security.Access value)
	{
		Instance.Access = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Access()
	{
		Instance.Access = Elastic.Clients.Elasticsearch.Security.AccessDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Access(System.Action<Elastic.Clients.Elasticsearch.Security.AccessDescriptor>? action)
	{
		Instance.Access = Elastic.Clients.Elasticsearch.Security.AccessDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Access<T>(System.Action<Elastic.Clients.Elasticsearch.Security.AccessDescriptor<T>>? action)
	{
		Instance.Access = Elastic.Clients.Elasticsearch.Security.AccessDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire. This property can be omitted to leave the value unchanged.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Expiration(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this information fully replaces metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this information fully replaces metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this information fully replaces metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Update a cross-cluster API key.
/// </para>
/// <para>
/// Update the attributes of an existing cross-cluster API key, which is used for API key based remote cluster access.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_security</c> cluster privilege.
/// Users can only update API keys that they created.
/// To update another user's API key, use the <c>run_as</c> feature to submit a request on behalf of another user.
/// </para>
/// <para>
/// IMPORTANT: It's not possible to use an API key as the authentication credential for this API.
/// To update an API key, the owner user's credentials are required.
/// </para>
/// <para>
/// It's not possible to update expired API keys, or API keys that have been invalidated by the invalidate API key API.
/// </para>
/// <para>
/// This API supports updates to an API key's access scope, metadata, and expiration.
/// The owner user's information, such as the <c>username</c> and <c>realm</c>, is also updated automatically on every call.
/// </para>
/// <para>
/// NOTE: This API cannot update REST API keys, which should be updated by either the update API key or bulk update API keys API.
/// </para>
/// <para>
/// To learn more about how to use this API, refer to the <a href="https://www.elastic.co/docs/reference/elasticsearch/rest-apis/update-cc-api-key-examples">Update cross cluter API key API examples page</a>.
/// </para>
/// </summary>
public readonly partial struct UpdateCrossClusterApiKeyRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateCrossClusterApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest instance)
	{
		Instance = instance;
	}

	public UpdateCrossClusterApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
#pragma warning disable CS0618
		Instance = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest(id);
#pragma warning restore CS0618
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateCrossClusterApiKeyRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest(Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the cross-cluster API key to update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Access(Elastic.Clients.Elasticsearch.Security.Access value)
	{
		Instance.Access = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Access()
	{
		Instance.Access = Elastic.Clients.Elasticsearch.Security.AccessDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The access to be granted to this API key.
	/// The access is composed of permissions for cross cluster search and cross cluster replication.
	/// At least one of them must be specified.
	/// When specified, the new access assignment fully replaces the previously assigned access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Access(System.Action<Elastic.Clients.Elasticsearch.Security.AccessDescriptor<TDocument>>? action)
	{
		Instance.Access = Elastic.Clients.Elasticsearch.Security.AccessDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire. This property can be omitted to leave the value unchanged.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Expiration(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this information fully replaces metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this information fully replaces metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this information fully replaces metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateCrossClusterApiKeyRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}