// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class UpdateApiKeyRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Update an API key.
/// </para>
/// <para>
/// Update attributes of an existing API key.
/// This API supports updates to an API key's access scope, expiration, and metadata.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_own_api_key</c> cluster privilege.
/// Users can only update API keys that they created or that were granted to them.
/// To update another user’s API key, use the <c>run_as</c> feature to submit a request on behalf of another user.
/// </para>
/// <para>
/// IMPORTANT: It's not possible to use an API key as the authentication credential for this API. The owner user’s credentials are required.
/// </para>
/// <para>
/// Use this API to update API keys created by the create API key or grant API Key APIs.
/// If you need to apply the same update to many API keys, you can use the bulk update API keys API to reduce overhead.
/// It's not possible to update expired API keys or API keys that have been invalidated by the invalidate API key API.
/// </para>
/// <para>
/// The access scope of an API key is derived from the <c>role_descriptors</c> you specify in the request and a snapshot of the owner user's permissions at the time of the request.
/// The snapshot of the owner's permissions is updated automatically on every call.
/// </para>
/// <para>
/// IMPORTANT: If you don't specify <c>role_descriptors</c> in the request, a call to this API might still change the API key's access scope.
/// This change can occur if the owner user's permissions have changed since the API key was created or last modified.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.UpdateApiKeyRequestConverter))]
public sealed partial class UpdateApiKeyRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateApiKeyRequest(Elastic.Clients.Elasticsearch.Id id) : base(r => r.Required("id", id))
	{
	}
#if NET7_0_OR_GREATER
	public UpdateApiKeyRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UpdateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityUpdateApiKey;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.update_api_key";

	/// <summary>
	/// <para>
	/// The ID of the API key to update.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Id Id { get => P<Elastic.Clients.Elasticsearch.Id>("id"); set => PR("id", value); }

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire.
	/// This property can be omitted to leave the expiration unchanged.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Expiration { get; set; }

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports a nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this value fully replaces the metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>? RoleDescriptors { get; set; }
}

/// <summary>
/// <para>
/// Update an API key.
/// </para>
/// <para>
/// Update attributes of an existing API key.
/// This API supports updates to an API key's access scope, expiration, and metadata.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_own_api_key</c> cluster privilege.
/// Users can only update API keys that they created or that were granted to them.
/// To update another user’s API key, use the <c>run_as</c> feature to submit a request on behalf of another user.
/// </para>
/// <para>
/// IMPORTANT: It's not possible to use an API key as the authentication credential for this API. The owner user’s credentials are required.
/// </para>
/// <para>
/// Use this API to update API keys created by the create API key or grant API Key APIs.
/// If you need to apply the same update to many API keys, you can use the bulk update API keys API to reduce overhead.
/// It's not possible to update expired API keys or API keys that have been invalidated by the invalidate API key API.
/// </para>
/// <para>
/// The access scope of an API key is derived from the <c>role_descriptors</c> you specify in the request and a snapshot of the owner user's permissions at the time of the request.
/// The snapshot of the owner's permissions is updated automatically on every call.
/// </para>
/// <para>
/// IMPORTANT: If you don't specify <c>role_descriptors</c> in the request, a call to this API might still change the API key's access scope.
/// This change can occur if the owner user's permissions have changed since the API key was created or last modified.
/// </para>
/// </summary>
public readonly partial struct UpdateApiKeyRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest instance)
	{
		Instance = instance;
	}

	public UpdateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateApiKeyRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the API key to update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire.
	/// This property can be omitted to leave the expiration unchanged.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor Expiration(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports a nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this value fully replaces the metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports a nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this value fully replaces the metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports a nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this value fully replaces the metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RoleDescriptors(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>? value)
	{
		Instance.RoleDescriptors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RoleDescriptors()
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RoleDescriptors(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor>? action)
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RoleDescriptors<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>>? action)
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor AddRoleDescriptor(string key, Elastic.Clients.Elasticsearch.Security.RoleDescriptor value)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RoleDescriptors(string key)
	{
		Instance.RoleDescriptors = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> { { key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RoleDescriptors(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null));
		}

		Instance.RoleDescriptors = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor AddRoleDescriptor(string key)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor AddRoleDescriptor(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor>? action)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor AddRoleDescriptor<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<T>>? action)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Update an API key.
/// </para>
/// <para>
/// Update attributes of an existing API key.
/// This API supports updates to an API key's access scope, expiration, and metadata.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_own_api_key</c> cluster privilege.
/// Users can only update API keys that they created or that were granted to them.
/// To update another user’s API key, use the <c>run_as</c> feature to submit a request on behalf of another user.
/// </para>
/// <para>
/// IMPORTANT: It's not possible to use an API key as the authentication credential for this API. The owner user’s credentials are required.
/// </para>
/// <para>
/// Use this API to update API keys created by the create API key or grant API Key APIs.
/// If you need to apply the same update to many API keys, you can use the bulk update API keys API to reduce overhead.
/// It's not possible to update expired API keys or API keys that have been invalidated by the invalidate API key API.
/// </para>
/// <para>
/// The access scope of an API key is derived from the <c>role_descriptors</c> you specify in the request and a snapshot of the owner user's permissions at the time of the request.
/// The snapshot of the owner's permissions is updated automatically on every call.
/// </para>
/// <para>
/// IMPORTANT: If you don't specify <c>role_descriptors</c> in the request, a call to this API might still change the API key's access scope.
/// This change can occur if the owner user's permissions have changed since the API key was created or last modified.
/// </para>
/// </summary>
public readonly partial struct UpdateApiKeyRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UpdateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest instance)
	{
		Instance = instance;
	}

	public UpdateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Id id)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest(id);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public UpdateApiKeyRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest(Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The ID of the API key to update.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> Id(Elastic.Clients.Elasticsearch.Id value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire.
	/// This property can be omitted to leave the expiration unchanged.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> Expiration(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports a nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this value fully replaces the metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports a nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this value fully replaces the metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key.
	/// It supports a nested data structure.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// When specified, this value fully replaces the metadata previously associated with the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> RoleDescriptors(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>? value)
	{
		Instance.RoleDescriptors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> RoleDescriptors()
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> RoleDescriptors(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>>? action)
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> AddRoleDescriptor(string key, Elastic.Clients.Elasticsearch.Security.RoleDescriptor value)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> RoleDescriptors(string key)
	{
		Instance.RoleDescriptors = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> { { key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// The role descriptors to assign to this API key.
	/// The API key's effective permissions are an intersection of its assigned privileges and the point in time snapshot of permissions of the owner user.
	/// You can assign new privileges by specifying them in this parameter.
	/// To remove assigned privileges, you can supply an empty <c>role_descriptors</c> parameter, that is to say, an empty object <c>{}</c>.
	/// If an API key has no assigned privileges, it inherits the owner user's full permissions.
	/// The snapshot of the owner's permissions is always updated, whether you supply the <c>role_descriptors</c> parameter or not.
	/// The structure of a role descriptor is the same as the request for the create API keys API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> RoleDescriptors(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null));
		}

		Instance.RoleDescriptors = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> AddRoleDescriptor(string key)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> AddRoleDescriptor(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>>? action)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.UpdateApiKeyRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}