// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class SuggestUserProfilesRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Suggest a user profile.
/// </para>
/// <para>
/// Get suggestions for user profiles that match specified search criteria.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions.
/// Individual users and external applications should not call this API directly.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.SuggestUserProfilesRequestConverter))]
public sealed partial class SuggestUserProfilesRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestParameters>
{
#if NET7_0_OR_GREATER
	public SuggestUserProfilesRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SuggestUserProfilesRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SuggestUserProfilesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecuritySuggestUserProfiles;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.suggest_user_profiles";

	/// <summary>
	/// <para>
	/// A comma-separated list of filters for the <c>data</c> field of the profile document.
	/// To return all content use <c>data=*</c>.
	/// To return a subset of content, use <c>data=&lt;key></c> to retrieve content nested under the specified <c>&lt;key></c>.
	/// By default, the API returns no <c>data</c> content.
	/// It is an error to specify <c>data</c> as both the query parameter and the request body field.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Data { get; set; }

	/// <summary>
	/// <para>
	/// Extra search criteria to improve relevance of the suggestion result.
	/// Profiles matching the spcified hint are ranked higher in the response.
	/// Profiles not matching the hint aren't excluded from the response as long as the profile matches the <c>name</c> field query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.Hint? Hint { get; set; }

	/// <summary>
	/// <para>
	/// A query string used to match name-related fields in user profile documents.
	/// Name-related fields are the user's <c>username</c>, <c>full_name</c>, and <c>email</c>.
	/// </para>
	/// </summary>
	public string? Name { get; set; }

	/// <summary>
	/// <para>
	/// The number of profiles to return.
	/// </para>
	/// </summary>
	public long? Size { get; set; }
}

/// <summary>
/// <para>
/// Suggest a user profile.
/// </para>
/// <para>
/// Get suggestions for user profiles that match specified search criteria.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions.
/// Individual users and external applications should not call this API directly.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// </summary>
public readonly partial struct SuggestUserProfilesRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SuggestUserProfilesRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest instance)
	{
		Instance = instance;
	}

	public SuggestUserProfilesRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest instance) => new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest(Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of filters for the <c>data</c> field of the profile document.
	/// To return all content use <c>data=*</c>.
	/// To return a subset of content, use <c>data=&lt;key></c> to retrieve content nested under the specified <c>&lt;key></c>.
	/// By default, the API returns no <c>data</c> content.
	/// It is an error to specify <c>data</c> as both the query parameter and the request body field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Data(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Data = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of filters for the <c>data</c> field of the profile document.
	/// To return all content use <c>data=*</c>.
	/// To return a subset of content, use <c>data=&lt;key></c> to retrieve content nested under the specified <c>&lt;key></c>.
	/// By default, the API returns no <c>data</c> content.
	/// It is an error to specify <c>data</c> as both the query parameter and the request body field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Data(params string[] values)
	{
		Instance.Data = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Extra search criteria to improve relevance of the suggestion result.
	/// Profiles matching the spcified hint are ranked higher in the response.
	/// Profiles not matching the hint aren't excluded from the response as long as the profile matches the <c>name</c> field query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Hint(Elastic.Clients.Elasticsearch.Security.Hint? value)
	{
		Instance.Hint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Extra search criteria to improve relevance of the suggestion result.
	/// Profiles matching the spcified hint are ranked higher in the response.
	/// Profiles not matching the hint aren't excluded from the response as long as the profile matches the <c>name</c> field query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Hint()
	{
		Instance.Hint = Elastic.Clients.Elasticsearch.Security.HintDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Extra search criteria to improve relevance of the suggestion result.
	/// Profiles matching the spcified hint are ranked higher in the response.
	/// Profiles not matching the hint aren't excluded from the response as long as the profile matches the <c>name</c> field query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Hint(System.Action<Elastic.Clients.Elasticsearch.Security.HintDescriptor>? action)
	{
		Instance.Hint = Elastic.Clients.Elasticsearch.Security.HintDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A query string used to match name-related fields in user profile documents.
	/// Name-related fields are the user's <c>username</c>, <c>full_name</c>, and <c>email</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of profiles to return.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Size(long? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SuggestUserProfilesRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}