// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class SamlServiceProviderMetadataRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Create SAML service provider metadata.
/// </para>
/// <para>
/// Generate SAML metadata for a SAML 2.0 Service Provider.
/// </para>
/// <para>
/// The SAML 2.0 specification provides a mechanism for Service Providers to describe their capabilities and configuration using a metadata file.
/// This API generates Service Provider metadata based on the configuration of a SAML realm in Elasticsearch.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.SamlServiceProviderMetadataRequestConverter))]
public sealed partial class SamlServiceProviderMetadataRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlServiceProviderMetadataRequest(Elastic.Clients.Elasticsearch.Name realmName) : base(r => r.Required("realm_name", realmName))
	{
	}
#if NET7_0_OR_GREATER
	public SamlServiceProviderMetadataRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SamlServiceProviderMetadataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecuritySamlServiceProviderMetadata;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.saml_service_provider_metadata";

	/// <summary>
	/// <para>
	/// The name of the SAML realm in Elasticsearch.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name RealmName { get => P<Elastic.Clients.Elasticsearch.Name>("realm_name"); set => PR("realm_name", value); }
}

/// <summary>
/// <para>
/// Create SAML service provider metadata.
/// </para>
/// <para>
/// Generate SAML metadata for a SAML 2.0 Service Provider.
/// </para>
/// <para>
/// The SAML 2.0 specification provides a mechanism for Service Providers to describe their capabilities and configuration using a metadata file.
/// This API generates Service Provider metadata based on the configuration of a SAML realm in Elasticsearch.
/// </para>
/// </summary>
public readonly partial struct SamlServiceProviderMetadataRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlServiceProviderMetadataRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest instance)
	{
		Instance = instance;
	}

	public SamlServiceProviderMetadataRequestDescriptor(Elastic.Clients.Elasticsearch.Name realmName)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest(realmName);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public SamlServiceProviderMetadataRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest instance) => new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest(Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the SAML realm in Elasticsearch.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor RealmName(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.RealmName = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlServiceProviderMetadataRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}