// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class SamlLogoutRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Logout of SAML.
/// </para>
/// <para>
/// Submits a request to invalidate an access token and refresh token.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// This API invalidates the tokens that were generated for a user by the SAML authenticate API.
/// If the SAML realm in Elasticsearch is configured accordingly and the SAML IdP supports this, the Elasticsearch response contains a URL to redirect the user to the IdP that contains a SAML logout request (starting an SP-initiated SAML Single Logout).
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.SamlLogoutRequestConverter))]
public sealed partial class SamlLogoutRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlLogoutRequest(string token)
	{
		Token = token;
	}
#if NET7_0_OR_GREATER
	public SamlLogoutRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SamlLogoutRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SamlLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecuritySamlLogout;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.saml_logout";

	/// <summary>
	/// <para>
	/// The refresh token that was returned as a response to calling the SAML authenticate API.
	/// Alternatively, the most recent refresh token that was received after refreshing the original access token.
	/// </para>
	/// </summary>
	public string? RefreshToken { get; set; }

	/// <summary>
	/// <para>
	/// The access token that was returned as a response to calling the SAML authenticate API.
	/// Alternatively, the most recent token that was received after refreshing the original one by using a <c>refresh_token</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Token { get; set; }
}

/// <summary>
/// <para>
/// Logout of SAML.
/// </para>
/// <para>
/// Submits a request to invalidate an access token and refresh token.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// This API invalidates the tokens that were generated for a user by the SAML authenticate API.
/// If the SAML realm in Elasticsearch is configured accordingly and the SAML IdP supports this, the Elasticsearch response contains a URL to redirect the user to the IdP that contains a SAML logout request (starting an SP-initiated SAML Single Logout).
/// </para>
/// </summary>
public readonly partial struct SamlLogoutRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlLogoutRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest instance)
	{
		Instance = instance;
	}

	public SamlLogoutRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest instance) => new Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest(Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The refresh token that was returned as a response to calling the SAML authenticate API.
	/// Alternatively, the most recent refresh token that was received after refreshing the original access token.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor RefreshToken(string? value)
	{
		Instance.RefreshToken = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The access token that was returned as a response to calling the SAML authenticate API.
	/// Alternatively, the most recent token that was received after refreshing the original one by using a <c>refresh_token</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor Token(string value)
	{
		Instance.Token = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.SamlLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlLogoutRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}