// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class SamlInvalidateRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Invalidate SAML.
/// </para>
/// <para>
/// Submit a SAML LogoutRequest message to Elasticsearch for consumption.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// The logout request comes from the SAML IdP during an IdP initiated Single Logout.
/// The custom web application can use this API to have Elasticsearch process the <c>LogoutRequest</c>.
/// After successful validation of the request, Elasticsearch invalidates the access token and refresh token that corresponds to that specific SAML principal and provides a URL that contains a SAML LogoutResponse message.
/// Thus the user can be redirected back to their IdP.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.SamlInvalidateRequestConverter))]
public sealed partial class SamlInvalidateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlInvalidateRequest(string queryString)
	{
		QueryString = queryString;
	}
#if NET7_0_OR_GREATER
	public SamlInvalidateRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SamlInvalidateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SamlInvalidateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecuritySamlInvalidate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.saml_invalidate";

	/// <summary>
	/// <para>
	/// The Assertion Consumer Service URL that matches the one of the SAML realm in Elasticsearch that should be used. You must specify either this parameter or the <c>realm</c> parameter.
	/// </para>
	/// </summary>
	public string? Acs { get; set; }

	/// <summary>
	/// <para>
	/// The query part of the URL that the user was redirected to by the SAML IdP to initiate the Single Logout.
	/// This query should include a single parameter named <c>SAMLRequest</c> that contains a SAML logout request that is deflated and Base64 encoded.
	/// If the SAML IdP has signed the logout request, the URL should include two extra parameters named <c>SigAlg</c> and <c>Signature</c> that contain the algorithm used for the signature and the signature value itself.
	/// In order for Elasticsearch to be able to verify the IdP's signature, the value of the <c>query_string</c> field must be an exact match to the string provided by the browser.
	/// The client application must not attempt to parse or process the string in any way.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string QueryString { get; set; }

	/// <summary>
	/// <para>
	/// The name of the SAML realm in Elasticsearch the configuration. You must specify either this parameter or the <c>acs</c> parameter.
	/// </para>
	/// </summary>
	public string? Realm { get; set; }
}

/// <summary>
/// <para>
/// Invalidate SAML.
/// </para>
/// <para>
/// Submit a SAML LogoutRequest message to Elasticsearch for consumption.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// The logout request comes from the SAML IdP during an IdP initiated Single Logout.
/// The custom web application can use this API to have Elasticsearch process the <c>LogoutRequest</c>.
/// After successful validation of the request, Elasticsearch invalidates the access token and refresh token that corresponds to that specific SAML principal and provides a URL that contains a SAML LogoutResponse message.
/// Thus the user can be redirected back to their IdP.
/// </para>
/// </summary>
public readonly partial struct SamlInvalidateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlInvalidateRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest instance)
	{
		Instance = instance;
	}

	public SamlInvalidateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest instance) => new Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest(Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The Assertion Consumer Service URL that matches the one of the SAML realm in Elasticsearch that should be used. You must specify either this parameter or the <c>realm</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor Acs(string? value)
	{
		Instance.Acs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The query part of the URL that the user was redirected to by the SAML IdP to initiate the Single Logout.
	/// This query should include a single parameter named <c>SAMLRequest</c> that contains a SAML logout request that is deflated and Base64 encoded.
	/// If the SAML IdP has signed the logout request, the URL should include two extra parameters named <c>SigAlg</c> and <c>Signature</c> that contain the algorithm used for the signature and the signature value itself.
	/// In order for Elasticsearch to be able to verify the IdP's signature, the value of the <c>query_string</c> field must be an exact match to the string provided by the browser.
	/// The client application must not attempt to parse or process the string in any way.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor QueryString(string value)
	{
		Instance.QueryString = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the SAML realm in Elasticsearch the configuration. You must specify either this parameter or the <c>acs</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor Realm(string? value)
	{
		Instance.Realm = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlInvalidateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}