// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class SamlCompleteLogoutRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Logout of SAML completely.
/// </para>
/// <para>
/// Verifies the logout response sent from the SAML IdP.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// The SAML IdP may send a logout response back to the SP after handling the SP-initiated SAML Single Logout.
/// This API verifies the response by ensuring the content is relevant and validating its signature.
/// An empty response is returned if the verification process is successful.
/// The response can be sent by the IdP with either the HTTP-Redirect or the HTTP-Post binding.
/// The caller of this API must prepare the request accordingly so that this API can handle either of them.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.SamlCompleteLogoutRequestConverter))]
public sealed partial class SamlCompleteLogoutRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlCompleteLogoutRequest(Elastic.Clients.Elasticsearch.Ids ids, string realm)
	{
		Ids = ids;
		Realm = realm;
	}
#if NET7_0_OR_GREATER
	public SamlCompleteLogoutRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SamlCompleteLogoutRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SamlCompleteLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecuritySamlCompleteLogout;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.saml_complete_logout";

	/// <summary>
	/// <para>
	/// If the SAML IdP sends the logout response with the HTTP-Post binding, this field must be set to the value of the SAMLResponse form parameter from the logout response.
	/// </para>
	/// </summary>
	public string? Content { get; set; }

	/// <summary>
	/// <para>
	/// A JSON array with all the valid SAML Request Ids that the caller of the API has for the current user.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Ids Ids { get; set; }

	/// <summary>
	/// <para>
	/// If the SAML IdP sends the logout response with the HTTP-Redirect binding, this field must be set to the query string of the redirect URI.
	/// </para>
	/// </summary>
	public string? QueryString { get; set; }

	/// <summary>
	/// <para>
	/// The name of the SAML realm in Elasticsearch for which the configuration is used to verify the logout response.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Realm { get; set; }
}

/// <summary>
/// <para>
/// Logout of SAML completely.
/// </para>
/// <para>
/// Verifies the logout response sent from the SAML IdP.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// The SAML IdP may send a logout response back to the SP after handling the SP-initiated SAML Single Logout.
/// This API verifies the response by ensuring the content is relevant and validating its signature.
/// An empty response is returned if the verification process is successful.
/// The response can be sent by the IdP with either the HTTP-Redirect or the HTTP-Post binding.
/// The caller of this API must prepare the request accordingly so that this API can handle either of them.
/// </para>
/// </summary>
public readonly partial struct SamlCompleteLogoutRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlCompleteLogoutRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest instance)
	{
		Instance = instance;
	}

	public SamlCompleteLogoutRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest instance) => new Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest(Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If the SAML IdP sends the logout response with the HTTP-Post binding, this field must be set to the value of the SAMLResponse form parameter from the logout response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor Content(string? value)
	{
		Instance.Content = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A JSON array with all the valid SAML Request Ids that the caller of the API has for the current user.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor Ids(Elastic.Clients.Elasticsearch.Ids value)
	{
		Instance.Ids = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If the SAML IdP sends the logout response with the HTTP-Redirect binding, this field must be set to the query string of the redirect URI.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor QueryString(string? value)
	{
		Instance.QueryString = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the SAML realm in Elasticsearch for which the configuration is used to verify the logout response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor Realm(string value)
	{
		Instance.Realm = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlCompleteLogoutRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}