// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class SamlAuthenticateRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Authenticate SAML.
/// </para>
/// <para>
/// Submit a SAML response message to Elasticsearch for consumption.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// The SAML message that is submitted can be:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// A response to a SAML authentication request that was previously created using the SAML prepare authentication API.
/// </para>
/// </item>
/// <item>
/// <para>
/// An unsolicited SAML message in the case of an IdP-initiated single sign-on (SSO) flow.
/// </para>
/// </item>
/// </list>
/// <para>
/// In either case, the SAML message needs to be a base64 encoded XML document with a root element of <c>&lt;Response></c>.
/// </para>
/// <para>
/// After successful validation, Elasticsearch responds with an Elasticsearch internal access token and refresh token that can be subsequently used for authentication.
/// This API endpoint essentially exchanges SAML responses that indicate successful authentication in the IdP for Elasticsearch access and refresh tokens, which can be used for authentication against Elasticsearch.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.SamlAuthenticateRequestConverter))]
public sealed partial class SamlAuthenticateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlAuthenticateRequest(string content, Elastic.Clients.Elasticsearch.Ids ids)
	{
		Content = content;
		Ids = ids;
	}
#if NET7_0_OR_GREATER
	public SamlAuthenticateRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SamlAuthenticateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SamlAuthenticateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecuritySamlAuthenticate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.saml_authenticate";

	/// <summary>
	/// <para>
	/// The SAML response as it was sent by the user's browser, usually a Base64 encoded XML document.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Content { get; set; }

	/// <summary>
	/// <para>
	/// A JSON array with all the valid SAML Request Ids that the caller of the API has for the current user.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Ids Ids { get; set; }

	/// <summary>
	/// <para>
	/// The name of the realm that should authenticate the SAML response. Useful in cases where many SAML realms are defined.
	/// </para>
	/// </summary>
	public string? Realm { get; set; }
}

/// <summary>
/// <para>
/// Authenticate SAML.
/// </para>
/// <para>
/// Submit a SAML response message to Elasticsearch for consumption.
/// </para>
/// <para>
/// NOTE: This API is intended for use by custom web applications other than Kibana.
/// If you are using Kibana, refer to the documentation for configuring SAML single-sign-on on the Elastic Stack.
/// </para>
/// <para>
/// The SAML message that is submitted can be:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// A response to a SAML authentication request that was previously created using the SAML prepare authentication API.
/// </para>
/// </item>
/// <item>
/// <para>
/// An unsolicited SAML message in the case of an IdP-initiated single sign-on (SSO) flow.
/// </para>
/// </item>
/// </list>
/// <para>
/// In either case, the SAML message needs to be a base64 encoded XML document with a root element of <c>&lt;Response></c>.
/// </para>
/// <para>
/// After successful validation, Elasticsearch responds with an Elasticsearch internal access token and refresh token that can be subsequently used for authentication.
/// This API endpoint essentially exchanges SAML responses that indicate successful authentication in the IdP for Elasticsearch access and refresh tokens, which can be used for authentication against Elasticsearch.
/// </para>
/// </summary>
public readonly partial struct SamlAuthenticateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SamlAuthenticateRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest instance)
	{
		Instance = instance;
	}

	public SamlAuthenticateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor(Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest instance) => new Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest(Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The SAML response as it was sent by the user's browser, usually a Base64 encoded XML document.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor Content(string value)
	{
		Instance.Content = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A JSON array with all the valid SAML Request Ids that the caller of the API has for the current user.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor Ids(Elastic.Clients.Elasticsearch.Ids value)
	{
		Instance.Ids = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the realm that should authenticate the SAML response. Useful in cases where many SAML realms are defined.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor Realm(string? value)
	{
		Instance.Realm = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.SamlAuthenticateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}