// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class QueryRoleRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Find roles with a query.
/// </para>
/// <para>
/// Get roles in a paginated manner.
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The query roles API does not retrieve roles that are defined in roles files, nor built-in ones.
/// You can optionally filter the results with a query.
/// Also, the results can be paginated and sorted.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.QueryRoleRequestConverter))]
public sealed partial class QueryRoleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.QueryRoleRequestParameters>
{
#if NET7_0_OR_GREATER
	public QueryRoleRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public QueryRoleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal QueryRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityQueryRole;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.query_role";

	/// <summary>
	/// <para>
	/// The starting document offset.
	/// It must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public int? From { get; set; }

	/// <summary>
	/// <para>
	/// A query to filter which roles to return.
	/// If the query parameter is missing, it is equivalent to a <c>match_all</c> query.
	/// The query supports a subset of query types, including <c>match_all</c>, <c>bool</c>, <c>term</c>, <c>terms</c>, <c>match</c>,
	/// <c>ids</c>, <c>prefix</c>, <c>wildcard</c>, <c>exists</c>, <c>range</c>, and <c>simple_query_string</c>.
	/// You can query the following information associated with roles: <c>name</c>, <c>description</c>, <c>metadata</c>,
	/// <c>applications.application</c>, <c>applications.privileges</c>, and <c>applications.resources</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleQuery? Query { get; set; }

	/// <summary>
	/// <para>
	/// The search after definition.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? SearchAfter { get; set; }

	/// <summary>
	/// <para>
	/// The number of hits to return.
	/// It must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public int? Size { get; set; }

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? Sort { get; set; }
}

/// <summary>
/// <para>
/// Find roles with a query.
/// </para>
/// <para>
/// Get roles in a paginated manner.
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The query roles API does not retrieve roles that are defined in roles files, nor built-in ones.
/// You can optionally filter the results with a query.
/// Also, the results can be paginated and sorted.
/// </para>
/// </summary>
public readonly partial struct QueryRoleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.QueryRoleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.QueryRoleRequest instance)
	{
		Instance = instance;
	}

	public QueryRoleRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.QueryRoleRequest instance) => new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The starting document offset.
	/// It must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query to filter which roles to return.
	/// If the query parameter is missing, it is equivalent to a <c>match_all</c> query.
	/// The query supports a subset of query types, including <c>match_all</c>, <c>bool</c>, <c>term</c>, <c>terms</c>, <c>match</c>,
	/// <c>ids</c>, <c>prefix</c>, <c>wildcard</c>, <c>exists</c>, <c>range</c>, and <c>simple_query_string</c>.
	/// You can query the following information associated with roles: <c>name</c>, <c>description</c>, <c>metadata</c>,
	/// <c>applications.application</c>, <c>applications.privileges</c>, and <c>applications.resources</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Query(Elastic.Clients.Elasticsearch.Security.RoleQuery? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query to filter which roles to return.
	/// If the query parameter is missing, it is equivalent to a <c>match_all</c> query.
	/// The query supports a subset of query types, including <c>match_all</c>, <c>bool</c>, <c>term</c>, <c>terms</c>, <c>match</c>,
	/// <c>ids</c>, <c>prefix</c>, <c>wildcard</c>, <c>exists</c>, <c>range</c>, and <c>simple_query_string</c>.
	/// You can query the following information associated with roles: <c>name</c>, <c>description</c>, <c>metadata</c>,
	/// <c>applications.application</c>, <c>applications.privileges</c>, and <c>applications.resources</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.Security.RoleQueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Security.RoleQueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A query to filter which roles to return.
	/// If the query parameter is missing, it is equivalent to a <c>match_all</c> query.
	/// The query supports a subset of query types, including <c>match_all</c>, <c>bool</c>, <c>term</c>, <c>terms</c>, <c>match</c>,
	/// <c>ids</c>, <c>prefix</c>, <c>wildcard</c>, <c>exists</c>, <c>range</c>, and <c>simple_query_string</c>.
	/// You can query the following information associated with roles: <c>name</c>, <c>description</c>, <c>metadata</c>,
	/// <c>applications.application</c>, <c>applications.privileges</c>, and <c>applications.resources</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.Security.RoleQueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Security.RoleQueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search after definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search after definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return.
	/// It must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Sort<T>(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<T>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.QueryRoleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Find roles with a query.
/// </para>
/// <para>
/// Get roles in a paginated manner.
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The query roles API does not retrieve roles that are defined in roles files, nor built-in ones.
/// You can optionally filter the results with a query.
/// Also, the results can be paginated and sorted.
/// </para>
/// </summary>
public readonly partial struct QueryRoleRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.QueryRoleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public QueryRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.QueryRoleRequest instance)
	{
		Instance = instance;
	}

	public QueryRoleRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.QueryRoleRequest instance) => new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The starting document offset.
	/// It must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> From(int? value)
	{
		Instance.From = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query to filter which roles to return.
	/// If the query parameter is missing, it is equivalent to a <c>match_all</c> query.
	/// The query supports a subset of query types, including <c>match_all</c>, <c>bool</c>, <c>term</c>, <c>terms</c>, <c>match</c>,
	/// <c>ids</c>, <c>prefix</c>, <c>wildcard</c>, <c>exists</c>, <c>range</c>, and <c>simple_query_string</c>.
	/// You can query the following information associated with roles: <c>name</c>, <c>description</c>, <c>metadata</c>,
	/// <c>applications.application</c>, <c>applications.privileges</c>, and <c>applications.resources</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.Security.RoleQuery? value)
	{
		Instance.Query = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A query to filter which roles to return.
	/// If the query parameter is missing, it is equivalent to a <c>match_all</c> query.
	/// The query supports a subset of query types, including <c>match_all</c>, <c>bool</c>, <c>term</c>, <c>terms</c>, <c>match</c>,
	/// <c>ids</c>, <c>prefix</c>, <c>wildcard</c>, <c>exists</c>, <c>range</c>, and <c>simple_query_string</c>.
	/// You can query the following information associated with roles: <c>name</c>, <c>description</c>, <c>metadata</c>,
	/// <c>applications.application</c>, <c>applications.privileges</c>, and <c>applications.resources</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.Security.RoleQueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.Security.RoleQueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The search after definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> SearchAfter(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.FieldValue>? value)
	{
		Instance.SearchAfter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The search after definition.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> SearchAfter(params Elastic.Clients.Elasticsearch.FieldValue[] values)
	{
		Instance.SearchAfter = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The number of hits to return.
	/// It must not be negative.
	/// By default, you cannot page through more than 10,000 hits using the <c>from</c> and <c>size</c> parameters.
	/// To page through more hits, use the <c>search_after</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Sort(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.SortOptions>? value)
	{
		Instance.Sort = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Sort(params Elastic.Clients.Elasticsearch.SortOptions[] values)
	{
		Instance.Sort = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// The sort definition.
	/// You can sort on <c>username</c>, <c>roles</c>, or <c>enabled</c>.
	/// In addition, sort can also be applied to the <c>_doc</c> field to sort by index order.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Sort(params System.Action<Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.SortOptions>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.SortOptionsDescriptor<TDocument>.Build(action));
		}

		Instance.Sort = items;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.QueryRoleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.QueryRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.QueryRoleRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}