// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class PutUserRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Valid values are <c>true</c>, <c>false</c>, and <c>wait_for</c>.
	/// These values have the same meaning as in the index API, but the default value for this API is true.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Create or update users.
/// </para>
/// <para>
/// Add and update users in the native realm.
/// A password is required for adding a new user but is optional when updating an existing user.
/// To change a user's password without updating any other fields, use the change password API.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.PutUserRequestConverter))]
public sealed partial class PutUserRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.PutUserRequestParameters>
{
#if NET7_0_OR_GREATER
	public PutUserRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public PutUserRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityPutUser;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.put_user";

	/// <summary>
	/// <para>
	/// Valid values are <c>true</c>, <c>false</c>, and <c>wait_for</c>.
	/// These values have the same meaning as in the index API, but the default value for this API is true.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// The email of the user.
	/// </para>
	/// </summary>
	public string? Email { get; set; }

	/// <summary>
	/// <para>
	/// Specifies whether the user is enabled.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// The full name of the user.
	/// </para>
	/// </summary>
	public string? FullName { get; set; }

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the user.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// The user's password.
	/// Passwords must be at least 6 characters long.
	/// When adding a user, one of <c>password</c> or <c>password_hash</c> is required.
	/// When updating an existing user, the password is optional, so that other fields on the user (such as their roles) may be updated without modifying the user's password
	/// </para>
	/// </summary>
	public string? Password { get; set; }

	/// <summary>
	/// <para>
	/// A hash of the user's password.
	/// This must be produced using the same hashing algorithm as has been configured for password storage.
	/// For more details, see the explanation of the <c>xpack.security.authc.password_hashing.algorithm</c> setting in the user cache and password hash algorithm documentation.
	/// Using this parameter allows the client to pre-hash the password for performance and/or confidentiality reasons.
	/// The <c>password</c> parameter and the <c>password_hash</c> parameter cannot be used in the same request.
	/// </para>
	/// </summary>
	public string? PasswordHash { get; set; }

	/// <summary>
	/// <para>
	/// A set of roles the user has.
	/// The roles determine the user's access permissions.
	/// To create a user without any roles, specify an empty list (<c>[]</c>).
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Roles { get; set; }
	public Elastic.Clients.Elasticsearch.Username? Username { get; set; }
}

/// <summary>
/// <para>
/// Create or update users.
/// </para>
/// <para>
/// Add and update users in the native realm.
/// A password is required for adding a new user but is optional when updating an existing user.
/// To change a user's password without updating any other fields, use the change password API.
/// </para>
/// </summary>
public readonly partial struct PutUserRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.PutUserRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutUserRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutUserRequest instance)
	{
		Instance = instance;
	}

	public PutUserRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.PutUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutUserRequest instance) => new Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.PutUserRequest(Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Valid values are <c>true</c>, <c>false</c>, and <c>wait_for</c>.
	/// These values have the same meaning as in the index API, but the default value for this API is true.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The email of the user.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Email(string? value)
	{
		Instance.Email = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies whether the user is enabled.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The full name of the user.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor FullName(string? value)
	{
		Instance.FullName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the user.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the user.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the user.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// The user's password.
	/// Passwords must be at least 6 characters long.
	/// When adding a user, one of <c>password</c> or <c>password_hash</c> is required.
	/// When updating an existing user, the password is optional, so that other fields on the user (such as their roles) may be updated without modifying the user's password
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Password(string? value)
	{
		Instance.Password = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A hash of the user's password.
	/// This must be produced using the same hashing algorithm as has been configured for password storage.
	/// For more details, see the explanation of the <c>xpack.security.authc.password_hashing.algorithm</c> setting in the user cache and password hash algorithm documentation.
	/// Using this parameter allows the client to pre-hash the password for performance and/or confidentiality reasons.
	/// The <c>password</c> parameter and the <c>password_hash</c> parameter cannot be used in the same request.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor PasswordHash(string? value)
	{
		Instance.PasswordHash = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of roles the user has.
	/// The roles determine the user's access permissions.
	/// To create a user without any roles, specify an empty list (<c>[]</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Roles(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Roles = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A set of roles the user has.
	/// The roles determine the user's access permissions.
	/// To create a user without any roles, specify an empty list (<c>[]</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Roles(params string[] values)
	{
		Instance.Roles = [.. values];
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Username(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.Username = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.PutUserRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.PutUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.PutUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutUserRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}