// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class PutRoleRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Create or update roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles in the native realm, rather than using file-based role management.
/// The create or update roles API cannot update roles that are defined in roles files.
/// File-based role management is not available in Elastic Serverless.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.PutRoleRequestConverter))]
public sealed partial class PutRoleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.PutRoleRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRoleRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public PutRoleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityPutRole;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.put_role";

	/// <summary>
	/// <para>
	/// The name of the role that is being created or updated. On Elasticsearch Serverless, the role name must begin with a letter or digit and can only contain letters, digits and the characters '_', '-', and '.'. Each role must have a unique name, as this will serve as the identifier for that role.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// A list of application privilege entries.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>? Applications { get; set; }

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster-level actions for users with this role.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? Cluster { get; set; }

	/// <summary>
	/// <para>
	/// Optional description of the role descriptor
	/// </para>
	/// </summary>
	public string? Description { get; set; }

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Global { get; set; }

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>? Indices { get; set; }

	/// <summary>
	/// <para>
	/// Optional metadata. Within the metadata object, keys that begin with an underscore (<c>_</c>) are reserved for system use.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// A list of remote cluster permissions entries.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>? RemoteCluster { get; set; }

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>? RemoteIndices { get; set; }

	/// <summary>
	/// <para>
	/// A list of users that the owners of this role can impersonate. <em>Note</em>: in Serverless, the run-as feature is disabled. For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? RunAs { get; set; }

	/// <summary>
	/// <para>
	/// Indicates roles that might be incompatible with the current cluster license, specifically roles with document and field level security. When the cluster license doesn’t allow certain features for a given role, this parameter is updated dynamically to list the incompatible features. If <c>enabled</c> is <c>false</c>, the role is ignored, but is still listed in the response from the authenticate API.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? TransientMetadata { get; set; }
}

/// <summary>
/// <para>
/// Create or update roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles in the native realm, rather than using file-based role management.
/// The create or update roles API cannot update roles that are defined in roles files.
/// File-based role management is not available in Elastic Serverless.
/// </para>
/// </summary>
public readonly partial struct PutRoleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.PutRoleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutRoleRequest instance)
	{
		Instance = instance;
	}

	public PutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.PutRoleRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutRoleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutRoleRequest instance) => new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.PutRoleRequest(Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the role that is being created or updated. On Elasticsearch Serverless, the role name must begin with a letter or digit and can only contain letters, digits and the characters '_', '-', and '.'. Each role must have a unique name, as this will serve as the identifier for that role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Applications(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>? value)
	{
		Instance.Applications = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Applications(params Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges[] values)
	{
		Instance.Applications = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Applications(params System.Action<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor.Build(action));
		}

		Instance.Applications = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster-level actions for users with this role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Cluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? value)
	{
		Instance.Cluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster-level actions for users with this role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Cluster(params Elastic.Clients.Elasticsearch.Security.ClusterPrivilege[] values)
	{
		Instance.Cluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional description of the role descriptor
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Global(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Global = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Global()
	{
		Instance.Global = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Global(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Global = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor AddGlobal(string key, object value)
	{
		Instance.Global ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Global.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Indices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Indices(params Elastic.Clients.Elasticsearch.Security.IndicesPrivileges[] values)
	{
		Instance.Indices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Indices(params System.Action<Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor.Build(action));
		}

		Instance.Indices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Indices<T>(params System.Action<Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<T>.Build(action));
		}

		Instance.Indices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional metadata. Within the metadata object, keys that begin with an underscore (<c>_</c>) are reserved for system use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional metadata. Within the metadata object, keys that begin with an underscore (<c>_</c>) are reserved for system use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional metadata. Within the metadata object, keys that begin with an underscore (<c>_</c>) are reserved for system use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote cluster permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RemoteCluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>? value)
	{
		Instance.RemoteCluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote cluster permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RemoteCluster(params Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges[] values)
	{
		Instance.RemoteCluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote cluster permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RemoteCluster(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor.Build(action));
		}

		Instance.RemoteCluster = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RemoteIndices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>? value)
	{
		Instance.RemoteIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RemoteIndices(params Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges[] values)
	{
		Instance.RemoteIndices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RemoteIndices(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor.Build(action));
		}

		Instance.RemoteIndices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RemoteIndices<T>(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<T>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<T>.Build(action));
		}

		Instance.RemoteIndices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the owners of this role can impersonate. <em>Note</em>: in Serverless, the run-as feature is disabled. For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RunAs(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RunAs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the owners of this role can impersonate. <em>Note</em>: in Serverless, the run-as feature is disabled. For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RunAs(params string[] values)
	{
		Instance.RunAs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates roles that might be incompatible with the current cluster license, specifically roles with document and field level security. When the cluster license doesn’t allow certain features for a given role, this parameter is updated dynamically to list the incompatible features. If <c>enabled</c> is <c>false</c>, the role is ignored, but is still listed in the response from the authenticate API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor TransientMetadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.TransientMetadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates roles that might be incompatible with the current cluster license, specifically roles with document and field level security. When the cluster license doesn’t allow certain features for a given role, this parameter is updated dynamically to list the incompatible features. If <c>enabled</c> is <c>false</c>, the role is ignored, but is still listed in the response from the authenticate API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor TransientMetadata()
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates roles that might be incompatible with the current cluster license, specifically roles with document and field level security. When the cluster license doesn’t allow certain features for a given role, this parameter is updated dynamically to list the incompatible features. If <c>enabled</c> is <c>false</c>, the role is ignored, but is still listed in the response from the authenticate API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor TransientMetadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor AddTransientMetadatum(string key, object value)
	{
		Instance.TransientMetadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.TransientMetadata.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.PutRoleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.PutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create or update roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles in the native realm, rather than using file-based role management.
/// The create or update roles API cannot update roles that are defined in roles files.
/// File-based role management is not available in Elastic Serverless.
/// </para>
/// </summary>
public readonly partial struct PutRoleRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.PutRoleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutRoleRequest instance)
	{
		Instance = instance;
	}

	public PutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.PutRoleRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutRoleRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.PutRoleRequest instance) => new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.PutRoleRequest(Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the role that is being created or updated. On Elasticsearch Serverless, the role name must begin with a letter or digit and can only contain letters, digits and the characters '_', '-', and '.'. Each role must have a unique name, as this will serve as the identifier for that role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Applications(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>? value)
	{
		Instance.Applications = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Applications(params Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges[] values)
	{
		Instance.Applications = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of application privilege entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Applications(params System.Action<Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.ApplicationPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.ApplicationPrivilegesDescriptor.Build(action));
		}

		Instance.Applications = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster-level actions for users with this role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Cluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.ClusterPrivilege>? value)
	{
		Instance.Cluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of cluster privileges. These privileges define the cluster-level actions for users with this role.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Cluster(params Elastic.Clients.Elasticsearch.Security.ClusterPrivilege[] values)
	{
		Instance.Cluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional description of the role descriptor
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Description(string? value)
	{
		Instance.Description = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Global(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Global = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Global()
	{
		Instance.Global = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// An object defining global privileges. A global privilege is a form of cluster privilege that is request-aware. Support for global privileges is currently limited to the management of application privileges.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Global(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Global = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> AddGlobal(string key, object value)
	{
		Instance.Global ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Global.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Indices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Indices(params Elastic.Clients.Elasticsearch.Security.IndicesPrivileges[] values)
	{
		Instance.Indices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of indices permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Indices(params System.Action<Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.IndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.IndicesPrivilegesDescriptor<TDocument>.Build(action));
		}

		Instance.Indices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional metadata. Within the metadata object, keys that begin with an underscore (<c>_</c>) are reserved for system use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional metadata. Within the metadata object, keys that begin with an underscore (<c>_</c>) are reserved for system use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Optional metadata. Within the metadata object, keys that begin with an underscore (<c>_</c>) are reserved for system use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote cluster permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RemoteCluster(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>? value)
	{
		Instance.RemoteCluster = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote cluster permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RemoteCluster(params Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges[] values)
	{
		Instance.RemoteCluster = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote cluster permissions entries.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RemoteCluster(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteClusterPrivilegesDescriptor.Build(action));
		}

		Instance.RemoteCluster = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RemoteIndices(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>? value)
	{
		Instance.RemoteIndices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RemoteIndices(params Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges[] values)
	{
		Instance.RemoteIndices = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of remote indices permissions entries.
	/// </para>
	/// <para>
	/// NOTE: Remote indices are effective for remote clusters configured with the API key based model.
	/// They have no effect for remote clusters configured with the certificate based model.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RemoteIndices(params System.Action<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivileges>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RemoteIndicesPrivilegesDescriptor<TDocument>.Build(action));
		}

		Instance.RemoteIndices = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the owners of this role can impersonate. <em>Note</em>: in Serverless, the run-as feature is disabled. For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RunAs(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RunAs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of users that the owners of this role can impersonate. <em>Note</em>: in Serverless, the run-as feature is disabled. For API compatibility, you can still specify an empty <c>run_as</c> field, but a non-empty list will be rejected.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RunAs(params string[] values)
	{
		Instance.RunAs = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates roles that might be incompatible with the current cluster license, specifically roles with document and field level security. When the cluster license doesn’t allow certain features for a given role, this parameter is updated dynamically to list the incompatible features. If <c>enabled</c> is <c>false</c>, the role is ignored, but is still listed in the response from the authenticate API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> TransientMetadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.TransientMetadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates roles that might be incompatible with the current cluster license, specifically roles with document and field level security. When the cluster license doesn’t allow certain features for a given role, this parameter is updated dynamically to list the incompatible features. If <c>enabled</c> is <c>false</c>, the role is ignored, but is still listed in the response from the authenticate API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> TransientMetadata()
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Indicates roles that might be incompatible with the current cluster license, specifically roles with document and field level security. When the cluster license doesn’t allow certain features for a given role, this parameter is updated dynamically to list the incompatible features. If <c>enabled</c> is <c>false</c>, the role is ignored, but is still listed in the response from the authenticate API.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> TransientMetadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.TransientMetadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> AddTransientMetadatum(string key, object value)
	{
		Instance.TransientMetadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.TransientMetadata.Add(key, value);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.PutRoleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.PutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}