// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class PutRoleMappingRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Create or update role mappings.
/// </para>
/// <para>
/// Role mappings define which roles are assigned to each user.
/// Each mapping has rules that identify users and a list of roles that are granted to those users.
/// The role mapping APIs are generally the preferred way to manage role mappings rather than using role mapping files. The create or update role mappings API cannot update role mappings that are defined in role mapping files.
/// </para>
/// <para>
/// NOTE: This API does not create roles. Rather, it maps users to existing roles.
/// Roles can be created by using the create or update roles API or roles files.
/// </para>
/// <para>
/// <strong>Role templates</strong>
/// </para>
/// <para>
/// The most common use for role mappings is to create a mapping from a known value on the user to a fixed role name.
/// For example, all users in the <c>cn=admin,dc=example,dc=com</c> LDAP group should be given the superuser role in Elasticsearch.
/// The <c>roles</c> field is used for this purpose.
/// </para>
/// <para>
/// For more complex needs, it is possible to use Mustache templates to dynamically determine the names of the roles that should be granted to the user.
/// The <c>role_templates</c> field is used for this purpose.
/// </para>
/// <para>
/// NOTE: To use role templates successfully, the relevant scripting feature must be enabled.
/// Otherwise, all attempts to create a role mapping with role templates fail.
/// </para>
/// <para>
/// All of the user fields that are available in the role mapping rules are also available in the role templates.
/// Thus it is possible to assign a user to a role that reflects their username, their groups, or the name of the realm to which they authenticated.
/// </para>
/// <para>
/// By default a template is evaluated to produce a single string that is the name of the role which should be assigned to the user.
/// If the format of the template is set to "json" then the template is expected to produce a JSON string or an array of JSON strings for the role names.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.PutRoleMappingRequestConverter))]
public sealed partial class PutRoleMappingRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRoleMappingRequest(Elastic.Clients.Elasticsearch.Name name) : base(r => r.Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public PutRoleMappingRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PutRoleMappingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityPutRoleMapping;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.put_role_mapping";

	/// <summary>
	/// <para>
	/// The distinct name that identifies the role mapping.
	/// The name is used solely as an identifier to facilitate interaction via the API; it does not affect the behavior of the mapping in any way.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Name { get => P<Elastic.Clients.Elasticsearch.Name>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// Mappings that have <c>enabled</c> set to <c>false</c> are ignored when role mapping is performed.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// Additional metadata that helps define which roles are assigned to each user.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// A list of role names that are granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Roles { get; set; }

	/// <summary>
	/// <para>
	/// A list of Mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleTemplate>? RoleTemplates { get; set; }

	/// <summary>
	/// <para>
	/// The rules that determine which users should be matched by the mapping.
	/// A rule is a logical condition that is expressed by using a JSON DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.RoleMappingRule? Rules { get; set; }
	public System.Collections.Generic.ICollection<string>? RunAs { get; set; }
}

/// <summary>
/// <para>
/// Create or update role mappings.
/// </para>
/// <para>
/// Role mappings define which roles are assigned to each user.
/// Each mapping has rules that identify users and a list of roles that are granted to those users.
/// The role mapping APIs are generally the preferred way to manage role mappings rather than using role mapping files. The create or update role mappings API cannot update role mappings that are defined in role mapping files.
/// </para>
/// <para>
/// NOTE: This API does not create roles. Rather, it maps users to existing roles.
/// Roles can be created by using the create or update roles API or roles files.
/// </para>
/// <para>
/// <strong>Role templates</strong>
/// </para>
/// <para>
/// The most common use for role mappings is to create a mapping from a known value on the user to a fixed role name.
/// For example, all users in the <c>cn=admin,dc=example,dc=com</c> LDAP group should be given the superuser role in Elasticsearch.
/// The <c>roles</c> field is used for this purpose.
/// </para>
/// <para>
/// For more complex needs, it is possible to use Mustache templates to dynamically determine the names of the roles that should be granted to the user.
/// The <c>role_templates</c> field is used for this purpose.
/// </para>
/// <para>
/// NOTE: To use role templates successfully, the relevant scripting feature must be enabled.
/// Otherwise, all attempts to create a role mapping with role templates fail.
/// </para>
/// <para>
/// All of the user fields that are available in the role mapping rules are also available in the role templates.
/// Thus it is possible to assign a user to a role that reflects their username, their groups, or the name of the realm to which they authenticated.
/// </para>
/// <para>
/// By default a template is evaluated to produce a single string that is the name of the role which should be assigned to the user.
/// If the format of the template is set to "json" then the template is expected to produce a JSON string or an array of JSON strings for the role names.
/// </para>
/// </summary>
public readonly partial struct PutRoleMappingRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRoleMappingRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest instance)
	{
		Instance = instance;
	}

	public PutRoleMappingRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutRoleMappingRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest instance) => new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The distinct name that identifies the role mapping.
	/// The name is used solely as an identifier to facilitate interaction via the API; it does not affect the behavior of the mapping in any way.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mappings that have <c>enabled</c> set to <c>false</c> are ignored when role mapping is performed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional metadata that helps define which roles are assigned to each user.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional metadata that helps define which roles are assigned to each user.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional metadata that helps define which roles are assigned to each user.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of role names that are granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Roles(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Roles = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of role names that are granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Roles(params string[] values)
	{
		Instance.Roles = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of Mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor RoleTemplates(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleTemplate>? value)
	{
		Instance.RoleTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of Mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor RoleTemplates(params Elastic.Clients.Elasticsearch.Security.RoleTemplate[] values)
	{
		Instance.RoleTemplates = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of Mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor RoleTemplates(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleTemplateDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleTemplate>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleTemplateDescriptor.Build(action));
		}

		Instance.RoleTemplates = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The rules that determine which users should be matched by the mapping.
	/// A rule is a logical condition that is expressed by using a JSON DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Rules(Elastic.Clients.Elasticsearch.Security.RoleMappingRule? value)
	{
		Instance.Rules = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The rules that determine which users should be matched by the mapping.
	/// A rule is a logical condition that is expressed by using a JSON DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Rules(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor> action)
	{
		Instance.Rules = Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The rules that determine which users should be matched by the mapping.
	/// A rule is a logical condition that is expressed by using a JSON DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Rules<T>(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>> action)
	{
		Instance.Rules = Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor RunAs(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RunAs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor RunAs(params string[] values)
	{
		Instance.RunAs = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create or update role mappings.
/// </para>
/// <para>
/// Role mappings define which roles are assigned to each user.
/// Each mapping has rules that identify users and a list of roles that are granted to those users.
/// The role mapping APIs are generally the preferred way to manage role mappings rather than using role mapping files. The create or update role mappings API cannot update role mappings that are defined in role mapping files.
/// </para>
/// <para>
/// NOTE: This API does not create roles. Rather, it maps users to existing roles.
/// Roles can be created by using the create or update roles API or roles files.
/// </para>
/// <para>
/// <strong>Role templates</strong>
/// </para>
/// <para>
/// The most common use for role mappings is to create a mapping from a known value on the user to a fixed role name.
/// For example, all users in the <c>cn=admin,dc=example,dc=com</c> LDAP group should be given the superuser role in Elasticsearch.
/// The <c>roles</c> field is used for this purpose.
/// </para>
/// <para>
/// For more complex needs, it is possible to use Mustache templates to dynamically determine the names of the roles that should be granted to the user.
/// The <c>role_templates</c> field is used for this purpose.
/// </para>
/// <para>
/// NOTE: To use role templates successfully, the relevant scripting feature must be enabled.
/// Otherwise, all attempts to create a role mapping with role templates fail.
/// </para>
/// <para>
/// All of the user fields that are available in the role mapping rules are also available in the role templates.
/// Thus it is possible to assign a user to a role that reflects their username, their groups, or the name of the realm to which they authenticated.
/// </para>
/// <para>
/// By default a template is evaluated to produce a single string that is the name of the role which should be assigned to the user.
/// If the format of the template is set to "json" then the template is expected to produce a JSON string or an array of JSON strings for the role names.
/// </para>
/// </summary>
public readonly partial struct PutRoleMappingRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PutRoleMappingRequestDescriptor(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest instance)
	{
		Instance = instance;
	}

	public PutRoleMappingRequestDescriptor(Elastic.Clients.Elasticsearch.Name name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public PutRoleMappingRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest instance) => new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest(Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The distinct name that identifies the role mapping.
	/// The name is used solely as an identifier to facilitate interaction via the API; it does not affect the behavior of the mapping in any way.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Mappings that have <c>enabled</c> set to <c>false</c> are ignored when role mapping is performed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional metadata that helps define which roles are assigned to each user.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional metadata that helps define which roles are assigned to each user.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Additional metadata that helps define which roles are assigned to each user.
	/// Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of role names that are granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Roles(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Roles = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of role names that are granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Roles(params string[] values)
	{
		Instance.Roles = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of Mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> RoleTemplates(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Security.RoleTemplate>? value)
	{
		Instance.RoleTemplates = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of Mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> RoleTemplates(params Elastic.Clients.Elasticsearch.Security.RoleTemplate[] values)
	{
		Instance.RoleTemplates = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of Mustache templates that will be evaluated to determine the roles names that should granted to the users that match the role mapping rules.
	/// Exactly one of <c>roles</c> or <c>role_templates</c> must be specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> RoleTemplates(params System.Action<Elastic.Clients.Elasticsearch.Security.RoleTemplateDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Security.RoleTemplate>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Security.RoleTemplateDescriptor.Build(action));
		}

		Instance.RoleTemplates = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// The rules that determine which users should be matched by the mapping.
	/// A rule is a logical condition that is expressed by using a JSON DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Rules(Elastic.Clients.Elasticsearch.Security.RoleMappingRule? value)
	{
		Instance.Rules = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The rules that determine which users should be matched by the mapping.
	/// A rule is a logical condition that is expressed by using a JSON DSL.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Rules(System.Action<Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>> action)
	{
		Instance.Rules = Elastic.Clients.Elasticsearch.Security.RoleMappingRuleDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> RunAs(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.RunAs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> RunAs(params string[] values)
	{
		Instance.RunAs = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.PutRoleMappingRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}