// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class OidcPrepareAuthenticationRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Prepare OpenID connect authentication.
/// </para>
/// <para>
/// Create an oAuth 2.0 authentication request as a URL string based on the configuration of the OpenID Connect authentication realm in Elasticsearch.
/// </para>
/// <para>
/// The response of this API is a URL pointing to the Authorization Endpoint of the configured OpenID Connect Provider, which can be used to redirect the browser of the user in order to continue the authentication process.
/// </para>
/// <para>
/// Elasticsearch exposes all the necessary OpenID Connect related functionality with the OpenID Connect APIs.
/// These APIs are used internally by Kibana in order to provide OpenID Connect based authentication, but can also be used by other, custom web applications or other clients.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.OidcPrepareAuthenticationRequestConverter))]
public sealed partial class OidcPrepareAuthenticationRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestParameters>
{
#if NET7_0_OR_GREATER
	public OidcPrepareAuthenticationRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public OidcPrepareAuthenticationRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal OidcPrepareAuthenticationRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityOidcPrepareAuthentication;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.oidc_prepare_authentication";

	/// <summary>
	/// <para>
	/// In the case of a third party initiated single sign on, this is the issuer identifier for the OP that the RP is to send the authentication request to.
	/// It cannot be specified when <em>realm</em> is specified.
	/// One of <em>realm</em> or <em>iss</em> is required.
	/// </para>
	/// </summary>
	public string? Iss { get; set; }

	/// <summary>
	/// <para>
	/// In the case of a third party initiated single sign on, it is a string value that is included in the authentication request as the <em>login_hint</em> parameter.
	/// This parameter is not valid when <em>realm</em> is specified.
	/// </para>
	/// </summary>
	public string? LoginHint { get; set; }

	/// <summary>
	/// <para>
	/// The value used to associate a client session with an ID token and to mitigate replay attacks.
	/// If the caller of the API does not provide a value, Elasticsearch will generate one with sufficient entropy and return it in the response.
	/// </para>
	/// </summary>
	public string? Nonce { get; set; }

	/// <summary>
	/// <para>
	/// The name of the OpenID Connect realm in Elasticsearch the configuration of which should be used in order to generate the authentication request.
	/// It cannot be specified when <em>iss</em> is specified.
	/// One of <em>realm</em> or <em>iss</em> is required.
	/// </para>
	/// </summary>
	public string? Realm { get; set; }

	/// <summary>
	/// <para>
	/// The value used to maintain state between the authentication request and the response, typically used as a Cross-Site Request Forgery mitigation.
	/// If the caller of the API does not provide a value, Elasticsearch will generate one with sufficient entropy and return it in the response.
	/// </para>
	/// </summary>
	public string? State { get; set; }
}

/// <summary>
/// <para>
/// Prepare OpenID connect authentication.
/// </para>
/// <para>
/// Create an oAuth 2.0 authentication request as a URL string based on the configuration of the OpenID Connect authentication realm in Elasticsearch.
/// </para>
/// <para>
/// The response of this API is a URL pointing to the Authorization Endpoint of the configured OpenID Connect Provider, which can be used to redirect the browser of the user in order to continue the authentication process.
/// </para>
/// <para>
/// Elasticsearch exposes all the necessary OpenID Connect related functionality with the OpenID Connect APIs.
/// These APIs are used internally by Kibana in order to provide OpenID Connect based authentication, but can also be used by other, custom web applications or other clients.
/// </para>
/// </summary>
public readonly partial struct OidcPrepareAuthenticationRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OidcPrepareAuthenticationRequestDescriptor(Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest instance)
	{
		Instance = instance;
	}

	public OidcPrepareAuthenticationRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor(Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest instance) => new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest(Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// In the case of a third party initiated single sign on, this is the issuer identifier for the OP that the RP is to send the authentication request to.
	/// It cannot be specified when <em>realm</em> is specified.
	/// One of <em>realm</em> or <em>iss</em> is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor Iss(string? value)
	{
		Instance.Iss = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// In the case of a third party initiated single sign on, it is a string value that is included in the authentication request as the <em>login_hint</em> parameter.
	/// This parameter is not valid when <em>realm</em> is specified.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor LoginHint(string? value)
	{
		Instance.LoginHint = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value used to associate a client session with an ID token and to mitigate replay attacks.
	/// If the caller of the API does not provide a value, Elasticsearch will generate one with sufficient entropy and return it in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor Nonce(string? value)
	{
		Instance.Nonce = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the OpenID Connect realm in Elasticsearch the configuration of which should be used in order to generate the authentication request.
	/// It cannot be specified when <em>iss</em> is specified.
	/// One of <em>realm</em> or <em>iss</em> is required.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor Realm(string? value)
	{
		Instance.Realm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The value used to maintain state between the authentication request and the response, typically used as a Cross-Site Request Forgery mitigation.
	/// If the caller of the API does not provide a value, Elasticsearch will generate one with sufficient entropy and return it in the response.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor State(string? value)
	{
		Instance.State = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcPrepareAuthenticationRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}