// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class OidcLogoutRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Logout of OpenID Connect.
/// </para>
/// <para>
/// Invalidate an access token and a refresh token that were generated as a response to the <c>/_security/oidc/authenticate</c> API.
/// </para>
/// <para>
/// If the OpenID Connect authentication realm in Elasticsearch is accordingly configured, the response to this call will contain a URI pointing to the end session endpoint of the OpenID Connect Provider in order to perform single logout.
/// </para>
/// <para>
/// Elasticsearch exposes all the necessary OpenID Connect related functionality with the OpenID Connect APIs.
/// These APIs are used internally by Kibana in order to provide OpenID Connect based authentication, but can also be used by other, custom web applications or other clients.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.OidcLogoutRequestConverter))]
public sealed partial class OidcLogoutRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OidcLogoutRequest(string token)
	{
		Token = token;
	}
#if NET7_0_OR_GREATER
	public OidcLogoutRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public OidcLogoutRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal OidcLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityOidcLogout;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.oidc_logout";

	/// <summary>
	/// <para>
	/// The refresh token to be invalidated.
	/// </para>
	/// </summary>
	public string? RefreshToken { get; set; }

	/// <summary>
	/// <para>
	/// The access token to be invalidated.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Token { get; set; }
}

/// <summary>
/// <para>
/// Logout of OpenID Connect.
/// </para>
/// <para>
/// Invalidate an access token and a refresh token that were generated as a response to the <c>/_security/oidc/authenticate</c> API.
/// </para>
/// <para>
/// If the OpenID Connect authentication realm in Elasticsearch is accordingly configured, the response to this call will contain a URI pointing to the end session endpoint of the OpenID Connect Provider in order to perform single logout.
/// </para>
/// <para>
/// Elasticsearch exposes all the necessary OpenID Connect related functionality with the OpenID Connect APIs.
/// These APIs are used internally by Kibana in order to provide OpenID Connect based authentication, but can also be used by other, custom web applications or other clients.
/// </para>
/// </summary>
public readonly partial struct OidcLogoutRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OidcLogoutRequestDescriptor(Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest instance)
	{
		Instance = instance;
	}

	public OidcLogoutRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor(Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest instance) => new Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest(Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The refresh token to be invalidated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor RefreshToken(string? value)
	{
		Instance.RefreshToken = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The access token to be invalidated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor Token(string value)
	{
		Instance.Token = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.OidcLogoutRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcLogoutRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}