// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class OidcAuthenticateRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Authenticate OpenID Connect.
/// </para>
/// <para>
/// Exchange an OpenID Connect authentication response message for an Elasticsearch internal access token and refresh token that can be subsequently used for authentication.
/// </para>
/// <para>
/// Elasticsearch exposes all the necessary OpenID Connect related functionality with the OpenID Connect APIs.
/// These APIs are used internally by Kibana in order to provide OpenID Connect based authentication, but can also be used by other, custom web applications or other clients.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.OidcAuthenticateRequestConverter))]
public sealed partial class OidcAuthenticateRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OidcAuthenticateRequest(string nonce, string redirectUri, string state)
	{
		Nonce = nonce;
		RedirectUri = redirectUri;
		State = state;
	}
#if NET7_0_OR_GREATER
	public OidcAuthenticateRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public OidcAuthenticateRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal OidcAuthenticateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityOidcAuthenticate;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.oidc_authenticate";

	/// <summary>
	/// <para>
	/// Associate a client session with an ID token and mitigate replay attacks.
	/// This value needs to be the same as the one that was provided to the <c>/_security/oidc/prepare</c> API or the one that was generated by Elasticsearch and included in the response to that call.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Nonce { get; set; }

	/// <summary>
	/// <para>
	/// The name of the OpenID Connect realm.
	/// This property is useful in cases where multiple realms are defined.
	/// </para>
	/// </summary>
	public string? Realm { get; set; }

	/// <summary>
	/// <para>
	/// The URL to which the OpenID Connect Provider redirected the User Agent in response to an authentication request after a successful authentication.
	/// This URL must be provided as-is (URL encoded), taken from the body of the response or as the value of a location header in the response from the OpenID Connect Provider.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RedirectUri { get; set; }

	/// <summary>
	/// <para>
	/// Maintain state between the authentication request and the response.
	/// This value needs to be the same as the one that was provided to the <c>/_security/oidc/prepare</c> API or the one that was generated by Elasticsearch and included in the response to that call.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string State { get; set; }
}

/// <summary>
/// <para>
/// Authenticate OpenID Connect.
/// </para>
/// <para>
/// Exchange an OpenID Connect authentication response message for an Elasticsearch internal access token and refresh token that can be subsequently used for authentication.
/// </para>
/// <para>
/// Elasticsearch exposes all the necessary OpenID Connect related functionality with the OpenID Connect APIs.
/// These APIs are used internally by Kibana in order to provide OpenID Connect based authentication, but can also be used by other, custom web applications or other clients.
/// </para>
/// </summary>
public readonly partial struct OidcAuthenticateRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OidcAuthenticateRequestDescriptor(Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest instance)
	{
		Instance = instance;
	}

	public OidcAuthenticateRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor(Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest instance) => new Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest(Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Associate a client session with an ID token and mitigate replay attacks.
	/// This value needs to be the same as the one that was provided to the <c>/_security/oidc/prepare</c> API or the one that was generated by Elasticsearch and included in the response to that call.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor Nonce(string value)
	{
		Instance.Nonce = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the OpenID Connect realm.
	/// This property is useful in cases where multiple realms are defined.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor Realm(string? value)
	{
		Instance.Realm = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The URL to which the OpenID Connect Provider redirected the User Agent in response to an authentication request after a successful authentication.
	/// This URL must be provided as-is (URL encoded), taken from the body of the response or as the value of a location header in the response from the OpenID Connect Provider.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor RedirectUri(string value)
	{
		Instance.RedirectUri = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Maintain state between the authentication request and the response.
	/// This value needs to be the same as the one that was provided to the <c>/_security/oidc/prepare</c> API or the one that was generated by Elasticsearch and included in the response to that call.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor State(string value)
	{
		Instance.State = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.OidcAuthenticateRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}