// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class InvalidateTokenRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Invalidate a token.
/// </para>
/// <para>
/// The access tokens returned by the get token API have a finite period of time for which they are valid.
/// After that time period, they can no longer be used.
/// The time period is defined by the <c>xpack.security.authc.token.timeout</c> setting.
/// </para>
/// <para>
/// The refresh tokens returned by the get token API are only valid for 24 hours.
/// They can also be used exactly once.
/// If you want to invalidate one or more access or refresh tokens immediately, use this invalidate token API.
/// </para>
/// <para>
/// NOTE: While all parameters are optional, at least one of them is required.
/// More specifically, either one of <c>token</c> or <c>refresh_token</c> parameters is required.
/// If none of these two are specified, then <c>realm_name</c> and/or <c>username</c> need to be specified.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.InvalidateTokenRequestConverter))]
public sealed partial class InvalidateTokenRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestParameters>
{
#if NET7_0_OR_GREATER
	public InvalidateTokenRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InvalidateTokenRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InvalidateTokenRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityInvalidateToken;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.invalidate_token";

	/// <summary>
	/// <para>
	/// The name of an authentication realm.
	/// This parameter cannot be used with either <c>refresh_token</c> or <c>token</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? RealmName { get; set; }

	/// <summary>
	/// <para>
	/// A refresh token.
	/// This parameter cannot be used if any of <c>refresh_token</c>, <c>realm_name</c>, or <c>username</c> are used.
	/// </para>
	/// </summary>
	public string? RefreshToken { get; set; }

	/// <summary>
	/// <para>
	/// An access token.
	/// This parameter cannot be used if any of <c>refresh_token</c>, <c>realm_name</c>, or <c>username</c> are used.
	/// </para>
	/// </summary>
	public string? Token { get; set; }

	/// <summary>
	/// <para>
	/// The username of a user.
	/// This parameter cannot be used with either <c>refresh_token</c> or <c>token</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Username? Username { get; set; }
}

/// <summary>
/// <para>
/// Invalidate a token.
/// </para>
/// <para>
/// The access tokens returned by the get token API have a finite period of time for which they are valid.
/// After that time period, they can no longer be used.
/// The time period is defined by the <c>xpack.security.authc.token.timeout</c> setting.
/// </para>
/// <para>
/// The refresh tokens returned by the get token API are only valid for 24 hours.
/// They can also be used exactly once.
/// If you want to invalidate one or more access or refresh tokens immediately, use this invalidate token API.
/// </para>
/// <para>
/// NOTE: While all parameters are optional, at least one of them is required.
/// More specifically, either one of <c>token</c> or <c>refresh_token</c> parameters is required.
/// If none of these two are specified, then <c>realm_name</c> and/or <c>username</c> need to be specified.
/// </para>
/// </summary>
public readonly partial struct InvalidateTokenRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InvalidateTokenRequestDescriptor(Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest instance)
	{
		Instance = instance;
	}

	public InvalidateTokenRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor(Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest instance) => new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest(Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of an authentication realm.
	/// This parameter cannot be used with either <c>refresh_token</c> or <c>token</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor RealmName(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.RealmName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A refresh token.
	/// This parameter cannot be used if any of <c>refresh_token</c>, <c>realm_name</c>, or <c>username</c> are used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor RefreshToken(string? value)
	{
		Instance.RefreshToken = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An access token.
	/// This parameter cannot be used if any of <c>refresh_token</c>, <c>realm_name</c>, or <c>username</c> are used.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor Token(string? value)
	{
		Instance.Token = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The username of a user.
	/// This parameter cannot be used with either <c>refresh_token</c> or <c>token</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor Username(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.Username = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateTokenRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}