// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class InvalidateApiKeyRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Invalidate API keys.
/// </para>
/// <para>
/// This API invalidates API keys created by the create API key or grant API key APIs.
/// Invalidated API keys fail authentication, but they can still be viewed using the get API key information and query API key information APIs, for at least the configured retention period, until they are automatically deleted.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_security</c>, <c>manage_api_key</c>, or <c>manage_own_api_key</c> cluster privileges.
/// The <c>manage_security</c> privilege allows deleting any API key, including both REST and cross cluster API keys.
/// The <c>manage_api_key</c> privilege allows deleting any REST API key, but not cross cluster API keys.
/// The <c>manage_own_api_key</c> only allows deleting REST API keys that are owned by the user.
/// In addition, with the <c>manage_own_api_key</c> privilege, an invalidation request must be issued in one of the three formats:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Set the parameter <c>owner=true</c>.
/// </para>
/// </item>
/// <item>
/// <para>
/// Or, set both <c>username</c> and <c>realm_name</c> to match the user's identity.
/// </para>
/// </item>
/// <item>
/// <para>
/// Or, if the request is issued by an API key, that is to say an API key invalidates itself, specify its ID in the <c>ids</c> field.
/// </para>
/// </item>
/// </list>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.InvalidateApiKeyRequestConverter))]
public sealed partial class InvalidateApiKeyRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestParameters>
{
#if NET7_0_OR_GREATER
	public InvalidateApiKeyRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public InvalidateApiKeyRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal InvalidateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityInvalidateApiKey;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.DELETE;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.invalidate_api_key";

	public Elastic.Clients.Elasticsearch.Id? Id { get; set; }

	/// <summary>
	/// <para>
	/// A list of API key ids.
	/// This parameter cannot be used with any of <c>name</c>, <c>realm_name</c>, or <c>username</c>.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id>? Ids { get; set; }

	/// <summary>
	/// <para>
	/// An API key name.
	/// This parameter cannot be used with any of <c>ids</c>, <c>realm_name</c> or <c>username</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Name { get; set; }

	/// <summary>
	/// <para>
	/// Query API keys owned by the currently authenticated user.
	/// The <c>realm_name</c> or <c>username</c> parameters cannot be specified when this parameter is set to <c>true</c> as they are assumed to be the currently authenticated ones.
	/// </para>
	/// <para>
	/// NOTE: At least one of <c>ids</c>, <c>name</c>, <c>username</c>, and <c>realm_name</c> must be specified if <c>owner</c> is <c>false</c>.
	/// </para>
	/// </summary>
	public bool? Owner { get; set; }

	/// <summary>
	/// <para>
	/// The name of an authentication realm.
	/// This parameter cannot be used with either <c>ids</c> or <c>name</c>, or when <c>owner</c> flag is set to <c>true</c>.
	/// </para>
	/// </summary>
	public string? RealmName { get; set; }

	/// <summary>
	/// <para>
	/// The username of a user.
	/// This parameter cannot be used with either <c>ids</c> or <c>name</c> or when <c>owner</c> flag is set to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Username? Username { get; set; }
}

/// <summary>
/// <para>
/// Invalidate API keys.
/// </para>
/// <para>
/// This API invalidates API keys created by the create API key or grant API key APIs.
/// Invalidated API keys fail authentication, but they can still be viewed using the get API key information and query API key information APIs, for at least the configured retention period, until they are automatically deleted.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>manage_security</c>, <c>manage_api_key</c>, or <c>manage_own_api_key</c> cluster privileges.
/// The <c>manage_security</c> privilege allows deleting any API key, including both REST and cross cluster API keys.
/// The <c>manage_api_key</c> privilege allows deleting any REST API key, but not cross cluster API keys.
/// The <c>manage_own_api_key</c> only allows deleting REST API keys that are owned by the user.
/// In addition, with the <c>manage_own_api_key</c> privilege, an invalidation request must be issued in one of the three formats:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// Set the parameter <c>owner=true</c>.
/// </para>
/// </item>
/// <item>
/// <para>
/// Or, set both <c>username</c> and <c>realm_name</c> to match the user's identity.
/// </para>
/// </item>
/// <item>
/// <para>
/// Or, if the request is issued by an API key, that is to say an API key invalidates itself, specify its ID in the <c>ids</c> field.
/// </para>
/// </item>
/// </list>
/// </summary>
public readonly partial struct InvalidateApiKeyRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public InvalidateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest instance)
	{
		Instance = instance;
	}

	public InvalidateApiKeyRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest(Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Id(Elastic.Clients.Elasticsearch.Id? value)
	{
		Instance.Id = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of API key ids.
	/// This parameter cannot be used with any of <c>name</c>, <c>realm_name</c>, or <c>username</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Ids(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Id>? value)
	{
		Instance.Ids = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of API key ids.
	/// This parameter cannot be used with any of <c>name</c>, <c>realm_name</c>, or <c>username</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Ids(params Elastic.Clients.Elasticsearch.Id[] values)
	{
		Instance.Ids = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// An API key name.
	/// This parameter cannot be used with any of <c>ids</c>, <c>realm_name</c> or <c>username</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query API keys owned by the currently authenticated user.
	/// The <c>realm_name</c> or <c>username</c> parameters cannot be specified when this parameter is set to <c>true</c> as they are assumed to be the currently authenticated ones.
	/// </para>
	/// <para>
	/// NOTE: At least one of <c>ids</c>, <c>name</c>, <c>username</c>, and <c>realm_name</c> must be specified if <c>owner</c> is <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Owner(bool? value = true)
	{
		Instance.Owner = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of an authentication realm.
	/// This parameter cannot be used with either <c>ids</c> or <c>name</c>, or when <c>owner</c> flag is set to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor RealmName(string? value)
	{
		Instance.RealmName = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The username of a user.
	/// This parameter cannot be used with either <c>ids</c> or <c>name</c> or when <c>owner</c> flag is set to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Username(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.Username = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.InvalidateApiKeyRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}