// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class HasPrivilegesUserProfileRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Check user profile privileges.
/// </para>
/// <para>
/// Determine whether the users associated with the specified user profile IDs have all the requested privileges.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions. Individual users and external applications should not call this API directly.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.HasPrivilegesUserProfileRequestConverter))]
public sealed partial class HasPrivilegesUserProfileRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HasPrivilegesUserProfileRequest(Elastic.Clients.Elasticsearch.Security.PrivilegesCheck privileges, System.Collections.Generic.ICollection<string> uids)
	{
		Privileges = privileges;
		Uids = uids;
	}
#if NET7_0_OR_GREATER
	public HasPrivilegesUserProfileRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public HasPrivilegesUserProfileRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal HasPrivilegesUserProfileRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityHasPrivilegesUserProfile;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.has_privileges_user_profile";

	/// <summary>
	/// <para>
	/// An object containing all the privileges to be checked.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Security.PrivilegesCheck Privileges { get; set; }

	/// <summary>
	/// <para>
	/// A list of profile IDs. The privileges are checked for associated users of the profiles.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.ICollection<string> Uids { get; set; }
}

/// <summary>
/// <para>
/// Check user profile privileges.
/// </para>
/// <para>
/// Determine whether the users associated with the specified user profile IDs have all the requested privileges.
/// </para>
/// <para>
/// NOTE: The user profile feature is designed only for use by Kibana and Elastic's Observability, Enterprise Search, and Elastic Security solutions. Individual users and external applications should not call this API directly.
/// Elastic reserves the right to change or remove this feature in future releases without prior notice.
/// </para>
/// </summary>
public readonly partial struct HasPrivilegesUserProfileRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public HasPrivilegesUserProfileRequestDescriptor(Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest instance)
	{
		Instance = instance;
	}

	public HasPrivilegesUserProfileRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor(Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest instance) => new Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest(Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An object containing all the privileges to be checked.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor Privileges(Elastic.Clients.Elasticsearch.Security.PrivilegesCheck value)
	{
		Instance.Privileges = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An object containing all the privileges to be checked.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor Privileges()
	{
		Instance.Privileges = Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// An object containing all the privileges to be checked.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor Privileges(System.Action<Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor>? action)
	{
		Instance.Privileges = Elastic.Clients.Elasticsearch.Security.PrivilegesCheckDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of profile IDs. The privileges are checked for associated users of the profiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor Uids(System.Collections.Generic.ICollection<string> value)
	{
		Instance.Uids = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A list of profile IDs. The privileges are checked for associated users of the profiles.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor Uids(params string[] values)
	{
		Instance.Uids = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.HasPrivilegesUserProfileRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}