// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class GrantApiKeyRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If 'true', Elasticsearch refreshes the affected shards to make this operation
	/// visible to search.
	/// If 'wait_for', it waits for a refresh to make this operation visible to search.
	/// If 'false', nothing is done with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Grant an API key.
/// </para>
/// <para>
/// Create an API key on behalf of another user.
/// This API is similar to the create API keys API, however it creates the API key for a user that is different than the user that runs the API.
/// The caller must have authentication credentials for the user on whose behalf the API key will be created.
/// It is not possible to use this API to create an API key without that user's credentials.
/// The supported user authentication credential types are:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// username and password
/// </para>
/// </item>
/// <item>
/// <para>
/// Elasticsearch access tokens
/// </para>
/// </item>
/// <item>
/// <para>
/// JWTs
/// </para>
/// </item>
/// </list>
/// <para>
/// The user, for whom the authentication credentials is provided, can optionally "run as" (impersonate) another user.
/// In this case, the API key will be created on behalf of the impersonated user.
/// </para>
/// <para>
/// This API is intended be used by applications that need to create and manage API keys for end users, but cannot guarantee that those users have permission to create API keys on their own behalf.
/// The API keys are created by the Elasticsearch API key service, which is automatically enabled.
/// </para>
/// <para>
/// A successful grant API key API call returns a JSON structure that contains the API key, its unique id, and its name.
/// If applicable, it also returns expiration information for the API key in milliseconds.
/// </para>
/// <para>
/// By default, API keys never expire. You can specify expiration information when you create the API keys.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.GrantApiKeyRequestConverter))]
public sealed partial class GrantApiKeyRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Security.GrantApiKey apiKey, Elastic.Clients.Elasticsearch.Security.ApiKeyGrantType grantType)
	{
		ApiKey = apiKey;
		GrantType = grantType;
	}
#if NET7_0_OR_GREATER
	public GrantApiKeyRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public GrantApiKeyRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityGrantApiKey;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.grant_api_key";

	/// <summary>
	/// <para>
	/// If 'true', Elasticsearch refreshes the affected shards to make this operation
	/// visible to search.
	/// If 'wait_for', it waits for a refresh to make this operation visible to search.
	/// If 'false', nothing is done with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// The user's access token.
	/// If you specify the <c>access_token</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public string? AccessToken { get; set; }

	/// <summary>
	/// <para>
	/// The API key.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Security.GrantApiKey ApiKey { get; set; }

	/// <summary>
	/// <para>
	/// The type of grant. Supported grant types are: <c>access_token</c>, <c>password</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Security.ApiKeyGrantType GrantType { get; set; }

	/// <summary>
	/// <para>
	/// The user's password.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public string? Password { get; set; }

	/// <summary>
	/// <para>
	/// The name of the user to be impersonated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Username? RunAs { get; set; }

	/// <summary>
	/// <para>
	/// The user name that identifies the user.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Username? Username { get; set; }
}

/// <summary>
/// <para>
/// Grant an API key.
/// </para>
/// <para>
/// Create an API key on behalf of another user.
/// This API is similar to the create API keys API, however it creates the API key for a user that is different than the user that runs the API.
/// The caller must have authentication credentials for the user on whose behalf the API key will be created.
/// It is not possible to use this API to create an API key without that user's credentials.
/// The supported user authentication credential types are:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// username and password
/// </para>
/// </item>
/// <item>
/// <para>
/// Elasticsearch access tokens
/// </para>
/// </item>
/// <item>
/// <para>
/// JWTs
/// </para>
/// </item>
/// </list>
/// <para>
/// The user, for whom the authentication credentials is provided, can optionally "run as" (impersonate) another user.
/// In this case, the API key will be created on behalf of the impersonated user.
/// </para>
/// <para>
/// This API is intended be used by applications that need to create and manage API keys for end users, but cannot guarantee that those users have permission to create API keys on their own behalf.
/// The API keys are created by the Elasticsearch API key service, which is automatically enabled.
/// </para>
/// <para>
/// A successful grant API key API call returns a JSON structure that contains the API key, its unique id, and its name.
/// If applicable, it also returns expiration information for the API key in milliseconds.
/// </para>
/// <para>
/// By default, API keys never expire. You can specify expiration information when you create the API keys.
/// </para>
/// </summary>
public readonly partial struct GrantApiKeyRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest instance)
	{
		Instance = instance;
	}

	public GrantApiKeyRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If 'true', Elasticsearch refreshes the affected shards to make this operation
	/// visible to search.
	/// If 'wait_for', it waits for a refresh to make this operation visible to search.
	/// If 'false', nothing is done with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The user's access token.
	/// If you specify the <c>access_token</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor AccessToken(string? value)
	{
		Instance.AccessToken = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor ApiKey(Elastic.Clients.Elasticsearch.Security.GrantApiKey value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor ApiKey(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor> action)
	{
		Instance.ApiKey = Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor ApiKey<T>(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<T>> action)
	{
		Instance.ApiKey = Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of grant. Supported grant types are: <c>access_token</c>, <c>password</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor GrantType(Elastic.Clients.Elasticsearch.Security.ApiKeyGrantType value)
	{
		Instance.GrantType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The user's password.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor Password(string? value)
	{
		Instance.Password = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the user to be impersonated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor RunAs(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.RunAs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The user name that identifies the user.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor Username(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.Username = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Grant an API key.
/// </para>
/// <para>
/// Create an API key on behalf of another user.
/// This API is similar to the create API keys API, however it creates the API key for a user that is different than the user that runs the API.
/// The caller must have authentication credentials for the user on whose behalf the API key will be created.
/// It is not possible to use this API to create an API key without that user's credentials.
/// The supported user authentication credential types are:
/// </para>
/// <list type="bullet">
/// <item>
/// <para>
/// username and password
/// </para>
/// </item>
/// <item>
/// <para>
/// Elasticsearch access tokens
/// </para>
/// </item>
/// <item>
/// <para>
/// JWTs
/// </para>
/// </item>
/// </list>
/// <para>
/// The user, for whom the authentication credentials is provided, can optionally "run as" (impersonate) another user.
/// In this case, the API key will be created on behalf of the impersonated user.
/// </para>
/// <para>
/// This API is intended be used by applications that need to create and manage API keys for end users, but cannot guarantee that those users have permission to create API keys on their own behalf.
/// The API keys are created by the Elasticsearch API key service, which is automatically enabled.
/// </para>
/// <para>
/// A successful grant API key API call returns a JSON structure that contains the API key, its unique id, and its name.
/// If applicable, it also returns expiration information for the API key in milliseconds.
/// </para>
/// <para>
/// By default, API keys never expire. You can specify expiration information when you create the API keys.
/// </para>
/// </summary>
public readonly partial struct GrantApiKeyRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GrantApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest instance)
	{
		Instance = instance;
	}

	public GrantApiKeyRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If 'true', Elasticsearch refreshes the affected shards to make this operation
	/// visible to search.
	/// If 'wait_for', it waits for a refresh to make this operation visible to search.
	/// If 'false', nothing is done with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The user's access token.
	/// If you specify the <c>access_token</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> AccessToken(string? value)
	{
		Instance.AccessToken = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> ApiKey(Elastic.Clients.Elasticsearch.Security.GrantApiKey value)
	{
		Instance.ApiKey = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> ApiKey(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument>> action)
	{
		Instance.ApiKey = Elastic.Clients.Elasticsearch.Security.GrantApiKeyDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The type of grant. Supported grant types are: <c>access_token</c>, <c>password</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> GrantType(Elastic.Clients.Elasticsearch.Security.ApiKeyGrantType value)
	{
		Instance.GrantType = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The user's password.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> Password(string? value)
	{
		Instance.Password = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the user to be impersonated.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> RunAs(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.RunAs = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The user name that identifies the user.
	/// If you specify the <c>password</c> grant type, this parameter is required.
	/// It is not valid with other grant types.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> Username(Elastic.Clients.Elasticsearch.Username? value)
	{
		Instance.Username = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}