// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security.Json;

public sealed partial class GrantApiKeyRequestConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest>
{
	private static readonly System.Text.Json.JsonEncodedText PropAccessToken = System.Text.Json.JsonEncodedText.Encode("access_token");
	private static readonly System.Text.Json.JsonEncodedText PropApiKey = System.Text.Json.JsonEncodedText.Encode("api_key");
	private static readonly System.Text.Json.JsonEncodedText PropGrantType = System.Text.Json.JsonEncodedText.Encode("grant_type");
	private static readonly System.Text.Json.JsonEncodedText PropPassword = System.Text.Json.JsonEncodedText.Encode("password");
	private static readonly System.Text.Json.JsonEncodedText PropRunAs = System.Text.Json.JsonEncodedText.Encode("run_as");
	private static readonly System.Text.Json.JsonEncodedText PropUsername = System.Text.Json.JsonEncodedText.Encode("username");

	public override Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propAccessToken = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Security.GrantApiKey> propApiKey = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Security.ApiKeyGrantType> propGrantType = default;
		LocalJsonValue<string?> propPassword = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Username?> propRunAs = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Username?> propUsername = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAccessToken.TryReadProperty(ref reader, options, PropAccessToken, null))
			{
				continue;
			}

			if (propApiKey.TryReadProperty(ref reader, options, PropApiKey, null))
			{
				continue;
			}

			if (propGrantType.TryReadProperty(ref reader, options, PropGrantType, null))
			{
				continue;
			}

			if (propPassword.TryReadProperty(ref reader, options, PropPassword, null))
			{
				continue;
			}

			if (propRunAs.TryReadProperty(ref reader, options, PropRunAs, null))
			{
				continue;
			}

			if (propUsername.TryReadProperty(ref reader, options, PropUsername, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AccessToken = propAccessToken.Value,
			ApiKey = propApiKey.Value,
			GrantType = propGrantType.Value,
			Password = propPassword.Value,
			RunAs = propRunAs.Value,
			Username = propUsername.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Security.GrantApiKeyRequest value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAccessToken, value.AccessToken, null, null);
		writer.WriteProperty(options, PropApiKey, value.ApiKey, null, null);
		writer.WriteProperty(options, PropGrantType, value.GrantType, null, null);
		writer.WriteProperty(options, PropPassword, value.Password, null, null);
		writer.WriteProperty(options, PropRunAs, value.RunAs, null, null);
		writer.WriteProperty(options, PropUsername, value.Username, null, null);
		writer.WriteEndObject();
	}
}