// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class GetUserRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// Determines whether to retrieve the user profile UID, if it exists, for the users.
	/// </para>
	/// </summary>
	public bool? WithProfileUid { get => Q<bool?>("with_profile_uid"); set => Q("with_profile_uid", value); }
}

/// <summary>
/// <para>
/// Get users.
/// </para>
/// <para>
/// Get information about users in the native realm and built-in users.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.GetUserRequestConverter))]
public sealed partial class GetUserRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.GetUserRequestParameters>
{
	public GetUserRequest(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? username) : base(r => r.Optional("username", username))
	{
	}
#if NET7_0_OR_GREATER
	public GetUserRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetUserRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityGetUser;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.get_user";

	/// <summary>
	/// <para>
	/// An identifier for the user. You can specify multiple usernames as a comma-separated list. If you omit this parameter, the API retrieves information about all users.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? Username { get => P<System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>?>("username"); set => PO("username", value); }

	/// <summary>
	/// <para>
	/// Determines whether to retrieve the user profile UID, if it exists, for the users.
	/// </para>
	/// </summary>
	public bool? WithProfileUid { get => Q<bool?>("with_profile_uid"); set => Q("with_profile_uid", value); }
}

/// <summary>
/// <para>
/// Get users.
/// </para>
/// <para>
/// Get information about users in the native realm and built-in users.
/// </para>
/// </summary>
public readonly partial struct GetUserRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.GetUserRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetUserRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GetUserRequest instance)
	{
		Instance = instance;
	}

	public GetUserRequestDescriptor(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? username)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GetUserRequest(username);
	}

	public GetUserRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GetUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GetUserRequest instance) => new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.GetUserRequest(Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// An identifier for the user. You can specify multiple usernames as a comma-separated list. If you omit this parameter, the API retrieves information about all users.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor Username(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Username>? value)
	{
		Instance.Username = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An identifier for the user. You can specify multiple usernames as a comma-separated list. If you omit this parameter, the API retrieves information about all users.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor Username(params Elastic.Clients.Elasticsearch.Username[] values)
	{
		Instance.Username = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Determines whether to retrieve the user profile UID, if it exists, for the users.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor WithProfileUid(bool? value = true)
	{
		Instance.WithProfileUid = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.GetUserRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.GetUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.GetUserRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetUserRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}