// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class GetServiceCredentialsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get service account credentials.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>read_security</c> cluster privilege (or a greater privilege such as <c>manage_service_account</c> or <c>manage_security</c>).
/// </para>
/// <para>
/// The response includes service account tokens that were created with the create service account tokens API as well as file-backed tokens from all nodes of the cluster.
/// </para>
/// <para>
/// NOTE: For tokens backed by the <c>service_tokens</c> file, the API collects them from all nodes of the cluster.
/// Tokens with the same name from different nodes are assumed to be the same token and are only counted once towards the total number of service tokens.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.GetServiceCredentialsRequestConverter))]
public sealed partial class GetServiceCredentialsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetServiceCredentialsRequest(string @namespace, Elastic.Clients.Elasticsearch.Name service) : base(r => r.Required("namespace", @namespace).Required("service", service))
	{
	}
#if NET7_0_OR_GREATER
	public GetServiceCredentialsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetServiceCredentialsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityGetServiceCredentials;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.get_service_credentials";

	/// <summary>
	/// <para>
	/// The name of the namespace.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Namespace { get => P<string>("namespace"); set => PR("namespace", value); }

	/// <summary>
	/// <para>
	/// The service name.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Service { get => P<Elastic.Clients.Elasticsearch.Name>("service"); set => PR("service", value); }
}

/// <summary>
/// <para>
/// Get service account credentials.
/// </para>
/// <para>
/// To use this API, you must have at least the <c>read_security</c> cluster privilege (or a greater privilege such as <c>manage_service_account</c> or <c>manage_security</c>).
/// </para>
/// <para>
/// The response includes service account tokens that were created with the create service account tokens API as well as file-backed tokens from all nodes of the cluster.
/// </para>
/// <para>
/// NOTE: For tokens backed by the <c>service_tokens</c> file, the API collects them from all nodes of the cluster.
/// Tokens with the same name from different nodes are assumed to be the same token and are only counted once towards the total number of service tokens.
/// </para>
/// </summary>
public readonly partial struct GetServiceCredentialsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetServiceCredentialsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest instance)
	{
		Instance = instance;
	}

	public GetServiceCredentialsRequestDescriptor(string @namespace, Elastic.Clients.Elasticsearch.Name service)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest(@namespace, service);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public GetServiceCredentialsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest instance) => new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest(Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the namespace.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor Namespace(string value)
	{
		Instance.Namespace = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The service name.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor Service(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Service = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceCredentialsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}