// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class GetServiceAccountsRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Get service accounts.
/// </para>
/// <para>
/// Get a list of service accounts that match the provided path parameters.
/// </para>
/// <para>
/// NOTE: Currently, only the <c>elastic/fleet-server</c> service account is available.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.GetServiceAccountsRequestConverter))]
public sealed partial class GetServiceAccountsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestParameters>
{
	public GetServiceAccountsRequest(string? @namespace, string? service) : base(r => r.Optional("namespace", @namespace).Optional("service", service))
	{
	}

	public GetServiceAccountsRequest(string? @namespace) : base(r => r.Optional("namespace", @namespace))
	{
	}
#if NET7_0_OR_GREATER
	public GetServiceAccountsRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public GetServiceAccountsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal GetServiceAccountsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityGetServiceAccounts;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.get_service_accounts";

	/// <summary>
	/// <para>
	/// The name of the namespace.
	/// Omit this parameter to retrieve information about all service accounts.
	/// If you omit this parameter, you must also omit the <c>service</c> parameter.
	/// </para>
	/// </summary>
	public string? Namespace { get => P<string?>("namespace"); set => PO("namespace", value); }

	/// <summary>
	/// <para>
	/// The service name.
	/// Omit this parameter to retrieve information about all service accounts that belong to the specified <c>namespace</c>.
	/// </para>
	/// </summary>
	public string? Service { get => P<string?>("service"); set => PO("service", value); }
}

/// <summary>
/// <para>
/// Get service accounts.
/// </para>
/// <para>
/// Get a list of service accounts that match the provided path parameters.
/// </para>
/// <para>
/// NOTE: Currently, only the <c>elastic/fleet-server</c> service account is available.
/// </para>
/// </summary>
public readonly partial struct GetServiceAccountsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public GetServiceAccountsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest instance)
	{
		Instance = instance;
	}

	public GetServiceAccountsRequestDescriptor(string? @namespace, string? service)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest(@namespace, service);
	}

	public GetServiceAccountsRequestDescriptor(string? @namespace)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest(@namespace);
	}

	public GetServiceAccountsRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest instance) => new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest(Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The name of the namespace.
	/// Omit this parameter to retrieve information about all service accounts.
	/// If you omit this parameter, you must also omit the <c>service</c> parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor Namespace(string? value)
	{
		Instance.Namespace = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The service name.
	/// Omit this parameter to retrieve information about all service accounts that belong to the specified <c>namespace</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor Service(string? value)
	{
		Instance.Service = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.GetServiceAccountsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}