// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class EnrollNodeRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Enroll a node.
/// </para>
/// <para>
/// Enroll a new node to allow it to join an existing cluster with security features enabled.
/// </para>
/// <para>
/// The response contains all the necessary information for the joining node to bootstrap discovery and security related settings so that it can successfully join the cluster.
/// The response contains key and certificate material that allows the caller to generate valid signed certificates for the HTTP layer of all nodes in the cluster.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.EnrollNodeRequestConverter))]
public sealed partial class EnrollNodeRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestParameters>
{
#if NET7_0_OR_GREATER
	public EnrollNodeRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public EnrollNodeRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EnrollNodeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityEnrollNode;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.GET;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.enroll_node";
}

/// <summary>
/// <para>
/// Enroll a node.
/// </para>
/// <para>
/// Enroll a new node to allow it to join an existing cluster with security features enabled.
/// </para>
/// <para>
/// The response contains all the necessary information for the joining node to bootstrap discovery and security related settings so that it can successfully join the cluster.
/// The response contains key and certificate material that allows the caller to generate valid signed certificates for the HTTP layer of all nodes in the cluster.
/// </para>
/// </summary>
public readonly partial struct EnrollNodeRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnrollNodeRequestDescriptor(Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest instance)
	{
		Instance = instance;
	}

	public EnrollNodeRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor(Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest instance) => new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest(Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor descriptor) => descriptor.Instance;

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.EnrollNodeRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.EnrollNodeRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}