// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class CreateApiKeyRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Create an API key.
/// </para>
/// <para>
/// Create an API key for access without requiring basic authentication.
/// </para>
/// <para>
/// IMPORTANT: If the credential that is used to authenticate this request is an API key, the derived API key cannot have any privileges.
/// If you specify privileges, the API returns an error.
/// </para>
/// <para>
/// A successful request returns a JSON structure that contains the API key, its unique id, and its name.
/// If applicable, it also returns expiration information for the API key in milliseconds.
/// </para>
/// <para>
/// NOTE: By default, API keys never expire. You can specify expiration information when you create the API keys.
/// </para>
/// <para>
/// The API keys are created by the Elasticsearch API key service, which is automatically enabled.
/// To configure or turn off the API key service, refer to API key service setting documentation.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.CreateApiKeyRequestConverter))]
public sealed partial class CreateApiKeyRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestParameters>
{
#if NET7_0_OR_GREATER
	public CreateApiKeyRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public CreateApiKeyRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityCreateApiKey;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.PUT;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.create_api_key";

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Expiration { get; set; }

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key. It supports nested data structure. Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, object>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// A name for the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Name? Name { get; set; }

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>? RoleDescriptors { get; set; }
}

/// <summary>
/// <para>
/// Create an API key.
/// </para>
/// <para>
/// Create an API key for access without requiring basic authentication.
/// </para>
/// <para>
/// IMPORTANT: If the credential that is used to authenticate this request is an API key, the derived API key cannot have any privileges.
/// If you specify privileges, the API returns an error.
/// </para>
/// <para>
/// A successful request returns a JSON structure that contains the API key, its unique id, and its name.
/// If applicable, it also returns expiration information for the API key in milliseconds.
/// </para>
/// <para>
/// NOTE: By default, API keys never expire. You can specify expiration information when you create the API keys.
/// </para>
/// <para>
/// The API keys are created by the Elasticsearch API key service, which is automatically enabled.
/// To configure or turn off the API key service, refer to API key service setting documentation.
/// </para>
/// </summary>
public readonly partial struct CreateApiKeyRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest instance)
	{
		Instance = instance;
	}

	public CreateApiKeyRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Expiration(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key. It supports nested data structure. Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key. It supports nested data structure. Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key. It supports nested data structure. Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A name for the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RoleDescriptors(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>? value)
	{
		Instance.RoleDescriptors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RoleDescriptors()
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RoleDescriptors(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor>? action)
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RoleDescriptors<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>>? action)
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor AddRoleDescriptor(string key, Elastic.Clients.Elasticsearch.Security.RoleDescriptor value)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RoleDescriptors(string key)
	{
		Instance.RoleDescriptors = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> { { key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RoleDescriptors(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null));
		}

		Instance.RoleDescriptors = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor AddRoleDescriptor(string key)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor AddRoleDescriptor(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor>? action)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor AddRoleDescriptor<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<T>>? action)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Create an API key.
/// </para>
/// <para>
/// Create an API key for access without requiring basic authentication.
/// </para>
/// <para>
/// IMPORTANT: If the credential that is used to authenticate this request is an API key, the derived API key cannot have any privileges.
/// If you specify privileges, the API returns an error.
/// </para>
/// <para>
/// A successful request returns a JSON structure that contains the API key, its unique id, and its name.
/// If applicable, it also returns expiration information for the API key in milliseconds.
/// </para>
/// <para>
/// NOTE: By default, API keys never expire. You can specify expiration information when you create the API keys.
/// </para>
/// <para>
/// The API keys are created by the Elasticsearch API key service, which is automatically enabled.
/// To configure or turn off the API key service, refer to API key service setting documentation.
/// </para>
/// </summary>
public readonly partial struct CreateApiKeyRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CreateApiKeyRequestDescriptor(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest instance)
	{
		Instance = instance;
	}

	public CreateApiKeyRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest instance) => new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The expiration time for the API key.
	/// By default, API keys never expire.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Expiration(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Expiration = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key. It supports nested data structure. Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Metadata(System.Collections.Generic.IDictionary<string, object>? value)
	{
		Instance.Metadata = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key. It supports nested data structure. Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Metadata()
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// Arbitrary metadata that you want to associate with the API key. It supports nested data structure. Within the metadata object, keys beginning with <c>_</c> are reserved for system usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Metadata(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject>? action)
	{
		Instance.Metadata = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringObject.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> AddMetadatum(string key, object value)
	{
		Instance.Metadata ??= new System.Collections.Generic.Dictionary<string, object>();
		Instance.Metadata.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A name for the API key.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> RoleDescriptors(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>? value)
	{
		Instance.RoleDescriptors = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> RoleDescriptors()
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> RoleDescriptors(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>>? action)
	{
		Instance.RoleDescriptors = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> AddRoleDescriptor(string key, Elastic.Clients.Elasticsearch.Security.RoleDescriptor value)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> RoleDescriptors(string key)
	{
		Instance.RoleDescriptors = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> { { key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// An array of role descriptors for this API key.
	/// When it is not specified or it is an empty array, the API key will have a point in time snapshot of permissions of the authenticated user.
	/// If you supply role descriptors, the resultant permissions are an intersection of API keys permissions and the authenticated user's permissions thereby limiting the access scope for API keys.
	/// The structure of role descriptor is the same as the request for the create role API.
	/// For more details, refer to the create or update roles API.
	/// </para>
	/// <para>
	/// NOTE: Due to the way in which this permission intersection is calculated, it is not possible to create an API key that is a child of another API key, unless the derived key is created without any privileges.
	/// In this case, you must explicitly specify a role descriptor with no privileges.
	/// The derived API key can be used for authentication; it will not have authority to call Elasticsearch APIs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> RoleDescriptors(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null));
		}

		Instance.RoleDescriptors = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> AddRoleDescriptor(string key)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> AddRoleDescriptor(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>>? action)
	{
		Instance.RoleDescriptors ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.RoleDescriptors.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.CreateApiKeyRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}