// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class ClearCachedServiceTokensRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Clear service account token caches.
/// </para>
/// <para>
/// Evict a subset of all entries from the service account token caches.
/// Two separate caches exist for service account tokens: one cache for tokens backed by the <c>service_tokens</c> file, and another for tokens backed by the <c>.security</c> index.
/// This API clears matching entries from both caches.
/// </para>
/// <para>
/// The cache for service account tokens backed by the <c>.security</c> index is cleared automatically on state changes of the security index.
/// The cache for tokens backed by the <c>service_tokens</c> file is cleared automatically on file changes.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ClearCachedServiceTokensRequestConverter))]
public sealed partial class ClearCachedServiceTokensRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedServiceTokensRequest(string @namespace, string service, Elastic.Clients.Elasticsearch.Names name) : base(r => r.Required("namespace", @namespace).Required("service", service).Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public ClearCachedServiceTokensRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClearCachedServiceTokensRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityClearCachedServiceTokens;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.clear_cached_service_tokens";

	/// <summary>
	/// <para>
	/// A comma-separated list of token names to evict from the service account token caches.
	/// Use a wildcard (<c>*</c>) to evict all tokens that belong to a service account.
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Names Name { get => P<Elastic.Clients.Elasticsearch.Names>("name"); set => PR("name", value); }

	/// <summary>
	/// <para>
	/// The namespace, which is a top-level grouping of service accounts.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Namespace { get => P<string>("namespace"); set => PR("namespace", value); }

	/// <summary>
	/// <para>
	/// The name of the service, which must be unique within its namespace.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Service { get => P<string>("service"); set => PR("service", value); }
}

/// <summary>
/// <para>
/// Clear service account token caches.
/// </para>
/// <para>
/// Evict a subset of all entries from the service account token caches.
/// Two separate caches exist for service account tokens: one cache for tokens backed by the <c>service_tokens</c> file, and another for tokens backed by the <c>.security</c> index.
/// This API clears matching entries from both caches.
/// </para>
/// <para>
/// The cache for service account tokens backed by the <c>.security</c> index is cleared automatically on state changes of the security index.
/// The cache for tokens backed by the <c>service_tokens</c> file is cleared automatically on file changes.
/// </para>
/// </summary>
public readonly partial struct ClearCachedServiceTokensRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedServiceTokensRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest instance)
	{
		Instance = instance;
	}

	public ClearCachedServiceTokensRequestDescriptor(string @namespace, string service, Elastic.Clients.Elasticsearch.Names name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest(@namespace, service, name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ClearCachedServiceTokensRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest instance) => new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest(Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of token names to evict from the service account token caches.
	/// Use a wildcard (<c>*</c>) to evict all tokens that belong to a service account.
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor Name(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.Name = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The namespace, which is a top-level grouping of service accounts.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor Namespace(string value)
	{
		Instance.Namespace = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The name of the service, which must be unique within its namespace.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor Service(string value)
	{
		Instance.Service = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedServiceTokensRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}