// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class ClearCachedRolesRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Clear the roles cache.
/// </para>
/// <para>
/// Evict roles from the native role cache.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ClearCachedRolesRequestConverter))]
public sealed partial class ClearCachedRolesRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedRolesRequest(Elastic.Clients.Elasticsearch.Names name) : base(r => r.Required("name", name))
	{
	}
#if NET7_0_OR_GREATER
	public ClearCachedRolesRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClearCachedRolesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityClearCachedRoles;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.clear_cached_roles";

	/// <summary>
	/// <para>
	/// A comma-separated list of roles to evict from the role cache.
	/// To evict all roles, use an asterisk (<c>*</c>).
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Names Name { get => P<Elastic.Clients.Elasticsearch.Names>("name"); set => PR("name", value); }
}

/// <summary>
/// <para>
/// Clear the roles cache.
/// </para>
/// <para>
/// Evict roles from the native role cache.
/// </para>
/// </summary>
public readonly partial struct ClearCachedRolesRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedRolesRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest instance)
	{
		Instance = instance;
	}

	public ClearCachedRolesRequestDescriptor(Elastic.Clients.Elasticsearch.Names name)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest(name);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ClearCachedRolesRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest instance) => new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest(Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of roles to evict from the role cache.
	/// To evict all roles, use an asterisk (<c>*</c>).
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor Name(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.Name = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRolesRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}