// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class ClearCachedRealmsRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// A comma-separated list of the users to clear from the cache.
	/// If you do not specify this parameter, the API evicts all users from the user cache.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Usernames { get => Q<System.Collections.Generic.ICollection<string>?>("usernames"); set => Q("usernames", value); }
}

/// <summary>
/// <para>
/// Clear the user cache.
/// </para>
/// <para>
/// Evict users from the user cache.
/// You can completely clear the cache or evict specific users.
/// </para>
/// <para>
/// User credentials are cached in memory on each node to avoid connecting to a remote authentication service or hitting the disk for every incoming request.
/// There are realm settings that you can use to configure the user cache.
/// For more information, refer to the documentation about controlling the user cache.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ClearCachedRealmsRequestConverter))]
public sealed partial class ClearCachedRealmsRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedRealmsRequest(Elastic.Clients.Elasticsearch.Names realms) : base(r => r.Required("realms", realms))
	{
	}
#if NET7_0_OR_GREATER
	public ClearCachedRealmsRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClearCachedRealmsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityClearCachedRealms;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.clear_cached_realms";

	/// <summary>
	/// <para>
	/// A comma-separated list of realms.
	/// To clear all realms, use an asterisk (<c>*</c>).
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Names Realms { get => P<Elastic.Clients.Elasticsearch.Names>("realms"); set => PR("realms", value); }

	/// <summary>
	/// <para>
	/// A comma-separated list of the users to clear from the cache.
	/// If you do not specify this parameter, the API evicts all users from the user cache.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Usernames { get => Q<System.Collections.Generic.ICollection<string>?>("usernames"); set => Q("usernames", value); }
}

/// <summary>
/// <para>
/// Clear the user cache.
/// </para>
/// <para>
/// Evict users from the user cache.
/// You can completely clear the cache or evict specific users.
/// </para>
/// <para>
/// User credentials are cached in memory on each node to avoid connecting to a remote authentication service or hitting the disk for every incoming request.
/// There are realm settings that you can use to configure the user cache.
/// For more information, refer to the documentation about controlling the user cache.
/// </para>
/// </summary>
public readonly partial struct ClearCachedRealmsRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedRealmsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest instance)
	{
		Instance = instance;
	}

	public ClearCachedRealmsRequestDescriptor(Elastic.Clients.Elasticsearch.Names realms)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest(realms);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ClearCachedRealmsRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest instance) => new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest(Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of realms.
	/// To clear all realms, use an asterisk (<c>*</c>).
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor Realms(Elastic.Clients.Elasticsearch.Names value)
	{
		Instance.Realms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of the users to clear from the cache.
	/// If you do not specify this parameter, the API evicts all users from the user cache.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor Usernames(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Usernames = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A comma-separated list of the users to clear from the cache.
	/// If you do not specify this parameter, the API evicts all users from the user cache.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor Usernames(params string[] values)
	{
		Instance.Usernames = [.. values];
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedRealmsRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}