// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class ClearCachedPrivilegesRequestParameters : Elastic.Transport.RequestParameters
{
}

/// <summary>
/// <para>
/// Clear the privileges cache.
/// </para>
/// <para>
/// Evict privileges from the native application privilege cache.
/// The cache is also automatically cleared for applications that have their privileges updated.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.ClearCachedPrivilegesRequestConverter))]
public sealed partial class ClearCachedPrivilegesRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedPrivilegesRequest(Elastic.Clients.Elasticsearch.Name application) : base(r => r.Required("application", application))
	{
	}
#if NET7_0_OR_GREATER
	public ClearCachedPrivilegesRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClearCachedPrivilegesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityClearCachedPrivileges;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => false;

	internal override string OperationName => "security.clear_cached_privileges";

	/// <summary>
	/// <para>
	/// A comma-separated list of applications.
	/// To clear all applications, use an asterism (<c>*</c>).
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Name Application { get => P<Elastic.Clients.Elasticsearch.Name>("application"); set => PR("application", value); }
}

/// <summary>
/// <para>
/// Clear the privileges cache.
/// </para>
/// <para>
/// Evict privileges from the native application privilege cache.
/// The cache is also automatically cleared for applications that have their privileges updated.
/// </para>
/// </summary>
public readonly partial struct ClearCachedPrivilegesRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClearCachedPrivilegesRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest instance)
	{
		Instance = instance;
	}

	public ClearCachedPrivilegesRequestDescriptor(Elastic.Clients.Elasticsearch.Name application)
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest(application);
	}

	[System.Obsolete("The use of the parameterless constructor is not permitted for this type.")]
	public ClearCachedPrivilegesRequestDescriptor()
	{
		throw new System.InvalidOperationException("The use of the parameterless constructor is not permitted for this type.");
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor(Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest instance) => new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest(Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// A comma-separated list of applications.
	/// To clear all applications, use an asterism (<c>*</c>).
	/// It does not support other wildcard patterns.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor Application(Elastic.Clients.Elasticsearch.Name value)
	{
		Instance.Application = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.ClearCachedPrivilegesRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}