// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Security;

public sealed partial class BulkPutRoleRequestParameters : Elastic.Transport.RequestParameters
{
	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }
}

/// <summary>
/// <para>
/// Bulk create or update roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The bulk create or update roles API cannot update roles that are defined in roles files.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Security.Json.BulkPutRoleRequestConverter))]
public sealed partial class BulkPutRoleRequest : Elastic.Clients.Elasticsearch.Requests.PlainRequest<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestParameters>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BulkPutRoleRequest(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> roles)
	{
		Roles = roles;
	}
#if NET7_0_OR_GREATER
	public BulkPutRoleRequest()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The request contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public BulkPutRoleRequest()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal BulkPutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	internal override Elastic.Clients.Elasticsearch.Requests.ApiUrls ApiUrls => Elastic.Clients.Elasticsearch.Requests.ApiUrlLookup.SecurityBulkPutRole;

	protected override Elastic.Transport.HttpMethod StaticHttpMethod => Elastic.Transport.HttpMethod.POST;

	internal override bool SupportsBody => true;

	internal override string OperationName => "security.bulk_put_role";

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Refresh? Refresh { get => Q<Elastic.Clients.Elasticsearch.Refresh?>("refresh"); set => Q("refresh", value); }

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> Roles { get; set; }
}

/// <summary>
/// <para>
/// Bulk create or update roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The bulk create or update roles API cannot update roles that are defined in roles files.
/// </para>
/// </summary>
public readonly partial struct BulkPutRoleRequestDescriptor
{
	internal Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BulkPutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest instance)
	{
		Instance = instance;
	}

	public BulkPutRoleRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest instance) => new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Roles(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> value)
	{
		Instance.Roles = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Roles()
	{
		Instance.Roles = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Roles(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor>? action)
	{
		Instance.Roles = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Roles<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>>? action)
	{
		Instance.Roles = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor AddRole(string key, Elastic.Clients.Elasticsearch.Security.RoleDescriptor value)
	{
		Instance.Roles ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.Roles.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Roles(string key)
	{
		Instance.Roles = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> { { key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Roles(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null));
		}

		Instance.Roles = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor AddRole(string key)
	{
		Instance.Roles ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.Roles.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor AddRole(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor>? action)
	{
		Instance.Roles ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.Roles.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor AddRole<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<T>>? action)
	{
		Instance.Roles ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.Roles.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<T>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor(new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}

/// <summary>
/// <para>
/// Bulk create or update roles.
/// </para>
/// <para>
/// The role management APIs are generally the preferred way to manage roles, rather than using file-based role management.
/// The bulk create or update roles API cannot update roles that are defined in roles files.
/// </para>
/// </summary>
public readonly partial struct BulkPutRoleRequestDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public BulkPutRoleRequestDescriptor(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest instance)
	{
		Instance = instance;
	}

	public BulkPutRoleRequestDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest instance) => new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest(Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c> (the default) then refresh the affected shards to make this operation visible to search, if <c>wait_for</c> then wait for a refresh to make this operation visible to search, if <c>false</c> then do nothing with refreshes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Refresh(Elastic.Clients.Elasticsearch.Refresh? value)
	{
		Instance.Refresh = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Roles(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> value)
	{
		Instance.Roles = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Roles()
	{
		Instance.Roles = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Roles(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>>? action)
	{
		Instance.Roles = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringRoleDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> AddRole(string key, Elastic.Clients.Elasticsearch.Security.RoleDescriptor value)
	{
		Instance.Roles ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.Roles.Add(key, value);
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Roles(string key)
	{
		Instance.Roles = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor> { { key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null) } };
		return this;
	}

	/// <summary>
	/// <para>
	/// A dictionary of role name to RoleDescriptor objects to add or update
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Roles(params string[] keys)
	{
		var items = new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		foreach (var key in keys)
		{
			items.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null));
		}

		Instance.Roles = items;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> AddRole(string key)
	{
		Instance.Roles ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.Roles.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> AddRole(string key, System.Action<Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>>? action)
	{
		Instance.Roles ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Security.RoleDescriptor>();
		Instance.Roles.Add(key, Elastic.Clients.Elasticsearch.Security.RoleDescriptorDescriptor<TDocument>.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest Build(System.Action<Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequest(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> ErrorTrace(bool? value)
	{
		Instance.ErrorTrace = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> FilterPath(params string[]? value)
	{
		Instance.FilterPath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Human(bool? value)
	{
		Instance.Human = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> Pretty(bool? value)
	{
		Instance.Pretty = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> SourceQueryString(string? value)
	{
		Instance.SourceQueryString = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> RequestConfiguration(Elastic.Transport.IRequestConfiguration? value)
	{
		Instance.RequestConfiguration = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Security.BulkPutRoleRequestDescriptor<TDocument> RequestConfiguration(System.Func<Elastic.Transport.RequestConfigurationDescriptor, Elastic.Transport.IRequestConfiguration>? configurationSelector)
	{
		Instance.RequestConfiguration = configurationSelector.Invoke(Instance.RequestConfiguration is null ? new Elastic.Transport.RequestConfigurationDescriptor() : new Elastic.Transport.RequestConfigurationDescriptor(Instance.RequestConfiguration)) ?? Instance.RequestConfiguration;
		return this;
	}
}